/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.proccess;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class WorkerThread
extends Thread {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkerThread");
    protected boolean stopped = false;
    protected long timeout;

    public WorkerThread(String name, long timeout) {
        super(name);
        this.timeout = timeout;
    }

    public WorkerThread(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                this.callPeriodically();
                WorkerThread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void halt() {
        this.stopped = true;
    }

    protected abstract void callPeriodically() throws Exception;
}

