/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.time.Instant;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;

public final class TemporalAccessor {
    public static final Instant[] EMPTY = new Instant[0];
    public final int dimension;
    public final DefaultTemporalCRS timeCRS;

    private TemporalAccessor(int n, TemporalCRS temporalCRS) {
        this.dimension = n;
        this.timeCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
    }

    public static TemporalAccessor of(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return new TemporalAccessor(n, (TemporalCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                TemporalAccessor temporalAccessor = TemporalAccessor.of(coordinateReferenceSystem2, n);
                if (temporalAccessor != null) {
                    return temporalAccessor;
                }
                n += ReferencingUtilities.getDimension(coordinateReferenceSystem2);
            }
        }
        return null;
    }

    public Instant[] getTimeBounds(AbstractEnvelope abstractEnvelope) {
        Instant instant = this.timeCRS.toInstant(abstractEnvelope.getLower(this.dimension));
        Instant instant2 = this.timeCRS.toInstant(abstractEnvelope.getUpper(this.dimension));
        if (instant == null) {
            if (instant2 == null) {
                return EMPTY;
            }
            instant = instant2;
            instant2 = null;
        }
        Instant[] instantArray = new Instant[instant2 != null ? 2 : 1];
        switch (instantArray.length) {
            default: {
                instantArray[1] = instant2;
            }
            case 1: {
                instantArray[0] = instant;
            }
            case 0: 
        }
        return instantArray;
    }

    public Range<Instant> getTimeRange(Envelope envelope) {
        return new Range(Instant.class, (Comparable)this.timeCRS.toInstant(envelope.getMinimum(this.dimension)), true, (Comparable)this.timeCRS.toInstant(envelope.getMaximum(this.dimension)), true);
    }

    void setTemporalExtent(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) {
        defaultTemporalExtent.setBounds(this.timeCRS.toDate(envelope.getMinimum(this.dimension)), this.timeCRS.toDate(envelope.getMaximum(this.dimension)));
    }
}

