/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util.ratestatistics;

import java.util.concurrent.TimeUnit;
import net.sf.ehcache.util.ratestatistics.RateStatistic;

abstract class AbstractRateStatistic
implements RateStatistic {
    private final long rateAveragePeriod;

    AbstractRateStatistic(long averagePeriod, TimeUnit unit) {
        this.rateAveragePeriod = unit.toNanos(averagePeriod);
    }

    long getRateAveragePeriod() {
        return this.rateAveragePeriod;
    }

    float iterateMovingAverage(float nowValue, long now, float thenAverage, long then) {
        if (this.getRateAveragePeriod() == 0L || Float.isNaN(thenAverage)) {
            return nowValue;
        }
        float alpha = (float)this.alpha(now, then);
        return alpha * nowValue + (1.0f - alpha) * thenAverage;
    }

    private double alpha(long now, long then) {
        return -Math.expm1(-((double)(now - then)) / (double)this.getRateAveragePeriod());
    }
}

