/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.internal.feature.Resources;

public class WritablePixelIterator
extends PixelIterator
implements Closeable {
    private final WritableRenderedImage destination;
    private WritableRaster destRaster;

    WritablePixelIterator(Raster raster, WritableRaster writableRaster, Rectangle rectangle, Dimension dimension, SequenceType sequenceType) {
        super(raster, rectangle, dimension, sequenceType);
        this.destRaster = writableRaster;
        this.destination = null;
        if (writableRaster != null) {
            if (!raster.getSampleModel().equals(writableRaster.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)46));
            }
            if (!raster.getBounds().equals(writableRaster.getBounds())) {
                throw new IllegalArgumentException(Resources.format((short)43));
            }
        }
    }

    WritablePixelIterator(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle, Dimension dimension, SequenceType sequenceType) {
        super(renderedImage, rectangle, dimension, sequenceType);
        this.destRaster = null;
        this.destination = writableRenderedImage;
        if (writableRenderedImage != null) {
            if (!renderedImage.getSampleModel().equals(writableRenderedImage.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)46));
            }
            if (renderedImage.getMinX() != writableRenderedImage.getMinX() || renderedImage.getMinY() != writableRenderedImage.getMinY() || renderedImage.getWidth() != writableRenderedImage.getWidth() || renderedImage.getHeight() != writableRenderedImage.getHeight()) {
                throw new IllegalArgumentException(Resources.format((short)43));
            }
            if (renderedImage.getMinTileX() != writableRenderedImage.getMinTileX() || renderedImage.getMinTileY() != writableRenderedImage.getMinTileY() || renderedImage.getTileWidth() != writableRenderedImage.getTileWidth() || renderedImage.getTileHeight() != writableRenderedImage.getTileHeight()) {
                throw new IllegalArgumentException(Resources.format((short)47));
            }
        }
    }

    public static WritablePixelIterator create(WritableRenderedImage writableRenderedImage) {
        return new PixelIterator.Builder().createWritable(writableRenderedImage);
    }

    @Override
    public boolean isWritable() {
        return this.destination != null || this.destRaster != null;
    }

    public void setSample(int n, int n2) {
        this.destRaster.setSample(this.x, this.y, n, n2);
    }

    public void setSample(int n, float f) {
        this.destRaster.setSample(this.x, this.y, n, f);
    }

    public void setSample(int n, double d) {
        this.destRaster.setSample(this.x, this.y, n, d);
    }

    public void setPixel(int[] nArray) {
        this.destRaster.setPixel(this.x, this.y, nArray);
    }

    public void setPixel(float[] fArray) {
        this.destRaster.setPixel(this.x, this.y, fArray);
    }

    public void setPixel(double[] dArray) {
        this.destRaster.setPixel(this.x, this.y, dArray);
    }

    public void setDataElements(Object object) {
        this.destRaster.setDataElements(this.x, this.y, object);
    }

    final WritableRaster destination() {
        return this.destRaster;
    }

    @Override
    final Raster fetchWritableTile() {
        if (this.destination != null) {
            this.destRaster = this.destination.getWritableTile(this.tileX, this.tileY);
            if (this.destination == this.image) {
                return this.destRaster;
            }
        }
        return super.fetchWritableTile();
    }

    @Override
    void releaseTile() {
        super.releaseTile();
        if (this.destination != null && this.destRaster != null) {
            this.destRaster = null;
            this.destination.releaseWritableTile(this.tileX, this.tileY);
        }
    }

    @Override
    public void close() {
        this.releaseTile();
    }
}

