/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.xpath;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NAryQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.xpath.Node;
import org.exoplatform.services.jcr.impl.core.query.xpath.ParseException;
import org.exoplatform.services.jcr.impl.core.query.xpath.QueryFormat;
import org.exoplatform.services.jcr.impl.core.query.xpath.SimpleNode;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPath;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPathTreeConstants;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPathVisitor;
import org.exoplatform.services.jcr.impl.util.ISO9075;

public class XPathQueryBuilder
implements XPathVisitor,
XPathTreeConstants {
    static final String NS_FN_URI = "http://www.w3.org/2005/xpath-functions";
    static final InternalQName FN_NOT = new InternalQName("http://www.w3.org/2005/xpath-functions", "not");
    static final InternalQName FN_LOWER_CASE = new InternalQName("http://www.w3.org/2005/xpath-functions", "lower-case");
    static final InternalQName FN_UPPER_CASE = new InternalQName("http://www.w3.org/2005/xpath-functions", "upper-case");
    static final InternalQName FN_NOT_10 = new InternalQName("", "not");
    static final InternalQName FN_TRUE = new InternalQName("", "true");
    static final InternalQName FN_FALSE = new InternalQName("", "false");
    static final InternalQName FN_POSITION = new InternalQName("", "position");
    static final InternalQName FN_ELEMENT = new InternalQName("", "element");
    static final InternalQName FN_POSITION_FULL = new InternalQName("", "position()");
    static final InternalQName JCR_XMLTEXT = new InternalQName("http://www.jcp.org/jcr/1.0", "xmltext");
    static final InternalQName FN_LAST = new InternalQName("", "last");
    static final InternalQName FN_FIRST = new InternalQName("", "first");
    static final InternalQName XS_DATETIME = new InternalQName("http://www.w3.org/2001/XMLSchema", "dateTime");
    static final InternalQName JCR_LIKE = new InternalQName("http://www.jcp.org/jcr/1.0", "like");
    static final InternalQName JCR_DEREF = new InternalQName("http://www.jcp.org/jcr/1.0", "deref");
    static final InternalQName JCR_CONTAINS = new InternalQName("http://www.jcp.org/jcr/1.0", "contains");
    static final InternalQName JCR_ROOT = new InternalQName("http://www.jcp.org/jcr/1.0", "root");
    static final InternalQName JCR_SCORE = new InternalQName("http://www.jcp.org/jcr/1.0", "score");
    static final InternalQName REP_SIMILAR = new InternalQName("internal", "similar");
    static final InternalQName REP_SPELLCHECK = new InternalQName("internal", "spellcheck");
    private static final String OP_EQ = "eq";
    private static final String OP_NE = "ne";
    private static final String OP_GT = "gt";
    private static final String OP_GE = "ge";
    private static final String OP_LT = "lt";
    private static final String OP_LE = "le";
    private static final String OP_SIGN_EQ = "=";
    private static final String OP_SIGN_NE = "!=";
    private static final String OP_SIGN_GT = ">";
    private static final String OP_SIGN_GE = ">=";
    private static final String OP_SIGN_LT = "<";
    private static final String OP_SIGN_LE = "<=";
    private static final Map<LocationFactory, XPath> parsers = new ReferenceMap(2, 2);
    private final QueryRootNode root;
    private final LocationFactory resolver;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private QPath tmpRelPath;
    private final QueryNodeFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathQueryBuilder(String statement, LocationFactory resolver, QueryNodeFactory factory) throws InvalidQueryException {
        this.resolver = resolver;
        this.factory = factory;
        this.root = factory.createQueryRootNode();
        try {
            SimpleNode query;
            XPath parser;
            statement = "for $v in " + (String)statement + " return $v";
            Map<LocationFactory, XPath> map = parsers;
            synchronized (map) {
                parser = parsers.get(resolver);
                if (parser == null) {
                    parser = new XPath(new StringReader((String)statement));
                    parsers.put(resolver, parser);
                }
            }
            XPath xPath = parser;
            synchronized (xPath) {
                parser.ReInit(new StringReader((String)statement));
                query = parser.XPath2();
            }
            query.jjtAccept(this, this.root);
        }
        catch (ParseException e) {
            throw new InvalidQueryException(e.getMessage() + " for statement: " + (String)statement, (Throwable)e);
        }
        catch (Throwable t) {
            throw new InvalidQueryException(t.getMessage() + " for statement: " + (String)statement, t);
        }
        if (this.exceptions.size() > 0) {
            Exception e = this.exceptions.get(0);
            if (e instanceof InvalidQueryException) {
                throw (InvalidQueryException)e;
            }
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static QueryRootNode createQuery(String statement, LocationFactory resolver, QueryNodeFactory factory) throws InvalidQueryException {
        return new XPathQueryBuilder(statement, resolver, factory).getRootNode();
    }

    public static String toString(QueryRootNode root, LocationFactory resolver) throws InvalidQueryException {
        return QueryFormat.toString(root, resolver);
    }

    QueryRootNode getRootNode() {
        return this.root;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        QueryNode queryNode = (QueryNode)data;
        switch (node.getId()) {
            case 0: {
                queryNode = this.createPathQueryNode(node);
                break;
            }
            case 120: 
            case 121: {
                if (queryNode instanceof PathQueryNode) {
                    ((PathQueryNode)queryNode).setAbsolute(true);
                    break;
                }
                this.exceptions.add((Exception)new InvalidQueryException("Unsupported root level query node: " + String.valueOf(queryNode)));
                break;
            }
            case 123: {
                if (this.isAttributeAxis(node)) {
                    if (queryNode.getType() == 2 || queryNode.getType() == 12 && ((DerefQueryNode)queryNode).getRefProperty() == null || queryNode.getType() == 3 || queryNode.getType() == 11 || queryNode.getType() == 4) {
                        node.childrenAccept(this, queryNode);
                        break;
                    }
                    if (queryNode.getType() == 9) {
                        RelationQueryNode isNull = this.factory.createRelationQueryNode(queryNode, 26);
                        this.applyRelativePath(isNull);
                        node.childrenAccept(this, isNull);
                        NotQueryNode notNode = (NotQueryNode)queryNode;
                        NAryQueryNode parent = (NAryQueryNode)notNode.getParent();
                        parent.removeOperand(notNode);
                        parent.addOperand(isNull);
                        break;
                    }
                    RelationQueryNode notNull = this.factory.createRelationQueryNode(queryNode, 27);
                    this.applyRelativePath(notNull);
                    node.childrenAccept(this, notNull);
                    ((NAryQueryNode)queryNode).addOperand(notNull);
                    break;
                }
                if (queryNode.getType() == 11) {
                    this.createLocationStep(node, (NAryQueryNode)queryNode);
                    break;
                }
                if (queryNode.getType() == 4 || queryNode.getType() == 2) {
                    node.childrenAccept(this, queryNode);
                    break;
                }
                RelationQueryNode tmp = this.factory.createRelationQueryNode(null, 27);
                node.childrenAccept(this, tmp);
                QPathEntry[] entr = tmp.getRelativePath().getEntries();
                if (this.tmpRelPath == null) {
                    this.tmpRelPath = new QPath(new QPathEntry[]{entr[entr.length - 1]});
                    break;
                }
                this.tmpRelPath = QPath.makeChildPath(this.tmpRelPath, entr[entr.length - 1]);
                break;
            }
            case 139: {
                if (queryNode.getType() == 10 || queryNode.getType() == 12 || queryNode.getType() == 2 || queryNode.getType() == 4 || queryNode.getType() == 11) {
                    this.createNodeTest(node, queryNode);
                    break;
                }
                if (queryNode.getType() == 3) {
                    this.createOrderSpec(node, (OrderQueryNode)queryNode);
                    break;
                }
                node.childrenAccept(this, queryNode);
                break;
            }
            case 261: {
                SimpleNode child;
                if (queryNode.getType() != 10 || (child = (SimpleNode)node.jjtGetChild(0)).getId() == 251) break;
                this.createNodeTest(child, queryNode);
                break;
            }
            case 238: {
                if (queryNode.getType() != 10) break;
                LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                loc.setNameTest(JCR_XMLTEXT);
                break;
            }
            case 270: {
                if (queryNode.getType() != 10) break;
                LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                String ntName = ((SimpleNode)node.jjtGetChild(0)).getValue();
                try {
                    InternalQName nt = this.resolver.parseJCRName(ntName).getInternalName();
                    NodeTypeQueryNode nodeType = this.factory.createNodeTypeQueryNode(loc, nt);
                    loc.addPredicate(nodeType);
                }
                catch (NamespaceException e) {
                    this.exceptions.add((Exception)new InvalidQueryException("Not a valid name: " + ntName));
                }
                catch (RepositoryException e) {
                    this.exceptions.add((Exception)new InvalidQueryException("Not a valid name: " + ntName));
                }
                break;
            }
            case 100: {
                NAryQueryNode parent = (NAryQueryNode)queryNode;
                OrQueryNode orQueryNode = this.factory.createOrQueryNode(parent);
                parent.addOperand(orQueryNode);
                node.childrenAccept(this, orQueryNode);
                break;
            }
            case 101: {
                NAryQueryNode parent = (NAryQueryNode)queryNode;
                AndQueryNode andQueryNode = this.factory.createAndQueryNode(parent);
                parent.addOperand(andQueryNode);
                node.childrenAccept(this, andQueryNode);
                break;
            }
            case 102: {
                this.createExpression(node, (NAryQueryNode)queryNode);
                break;
            }
            case 47: 
            case 146: 
            case 147: 
            case 148: {
                if (queryNode.getType() == 2) {
                    this.assignValue(node, (RelationQueryNode)queryNode);
                    break;
                }
                if (queryNode.getType() == 10) {
                    if (node.getId() == 146) {
                        int index = Integer.parseInt(node.getValue());
                        ((LocationStepQueryNode)queryNode).setIndex(index);
                        break;
                    }
                    this.exceptions.add((Exception)new InvalidQueryException("LocationStep only allows integer literal as position index"));
                    break;
                }
                this.exceptions.add((Exception)new InvalidQueryException("Parse error: data is not a RelationQueryNode"));
                break;
            }
            case 114: {
                if (queryNode.getType() == 2) {
                    ((RelationQueryNode)queryNode).setUnaryMinus(true);
                    break;
                }
                this.exceptions.add((Exception)new InvalidQueryException("Parse error: data is not a RelationQueryNode"));
                break;
            }
            case 152: {
                queryNode = this.createFunction(node, queryNode);
                break;
            }
            case 81: {
                this.root.setOrderNode(this.factory.createOrderQueryNode(this.root));
                queryNode = this.root.getOrderNode();
                node.childrenAccept(this, queryNode);
                break;
            }
            case 86: {
                if (node.jjtGetNumChildren() <= 0 || ((SimpleNode)node.jjtGetChild(0)).getId() != 88) break;
                OrderQueryNode.OrderSpec[] specs = ((OrderQueryNode)queryNode).getOrderSpecs();
                specs[specs.length - 1].setAscending(false);
                break;
            }
            case 144: {
                if (queryNode.getType() == 11) {
                    QueryNode[] operands = ((PathQueryNode)queryNode).getOperands();
                    queryNode = operands[operands.length - 1];
                }
                node.childrenAccept(this, queryNode);
                break;
            }
            case 145: {
                if (queryNode.getType() == 10 || queryNode.getType() == 12) {
                    node.childrenAccept(this, queryNode);
                    break;
                }
                this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for predicate"));
                break;
            }
            case 137: {
                this.exceptions.add((Exception)new InvalidQueryException("Parent axis is not supported"));
                break;
            }
            default: {
                node.childrenAccept(this, queryNode);
            }
        }
        return queryNode;
    }

    private void applyRelativePath(RelationQueryNode node) {
        if (this.tmpRelPath != null) {
            QPath relPath = this.tmpRelPath;
            for (int i = 0; i < relPath.getEntries().length; ++i) {
                node.addPathElement(relPath.getEntries()[i]);
            }
            this.tmpRelPath = null;
        }
    }

    private QPath getRelativePath() {
        try {
            if (this.tmpRelPath != null) {
                QPath qPath = this.tmpRelPath;
                return qPath;
            }
        }
        finally {
            this.tmpRelPath = null;
        }
        return null;
    }

    private LocationStepQueryNode createLocationStep(SimpleNode node, NAryQueryNode parent) {
        LocationStepQueryNode queryNode = null;
        boolean descendant = false;
        Node p = node.jjtGetParent();
        for (int i = 0; i < p.jjtGetNumChildren(); ++i) {
            SimpleNode c = (SimpleNode)p.jjtGetChild(i);
            if (c == node) {
                queryNode = this.factory.createLocationStepQueryNode(parent);
                queryNode.setNameTest(null);
                queryNode.setIncludeDescendants(descendant);
                parent.addOperand(queryNode);
                break;
            }
            descendant = c.getId() == 122 || c.getId() == 121;
        }
        node.childrenAccept(this, queryNode);
        return queryNode;
    }

    private void createNodeTest(SimpleNode node, QueryNode queryNode) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(0);
            if (child.getId() == 140 || child.getId() == 268) {
                try {
                    InternalQName name = XPathQueryBuilder.decode(this.resolver.parseJCRName(child.getValue()).getInternalName());
                    if (queryNode.getType() == 10) {
                        if (name.equals((Object)JCR_ROOT)) {
                            name = LocationStepQueryNode.EMPTY_NAME;
                        }
                        ((LocationStepQueryNode)queryNode).setNameTest(name);
                    } else if (queryNode.getType() == 12) {
                        ((DerefQueryNode)queryNode).setRefProperty(name);
                    } else if (queryNode.getType() == 2) {
                        ((RelationQueryNode)queryNode).addPathElement(new QPathEntry(name, 0));
                    } else if (queryNode.getType() == 11) {
                        this.root.addSelectProperty(name);
                    } else if (queryNode.getType() == 3) {
                        this.root.getOrderNode().addOrderSpec(name, true);
                    } else if (queryNode.getType() == 4) {
                        TextsearchQueryNode ts = (TextsearchQueryNode)queryNode;
                        ts.addPathElement(new QPathEntry(name, 0));
                        if (this.isAttributeNameTest(node)) {
                            ts.setReferencesProperty(true);
                        }
                    }
                }
                catch (RepositoryException e) {
                    this.exceptions.add((Exception)new InvalidQueryException("Illegal name: " + child.getValue()));
                }
            } else if (child.getId() == 141) {
                if (queryNode.getType() == 10) {
                    ((LocationStepQueryNode)queryNode).setNameTest(null);
                } else if (queryNode.getType() == 2) {
                    ((RelationQueryNode)queryNode).addPathElement(new QPathEntry(RelationQueryNode.STAR_NAME_TEST, 0));
                } else if (queryNode.getType() == 4) {
                    ((TextsearchQueryNode)queryNode).addPathElement(new QPathEntry(RelationQueryNode.STAR_NAME_TEST, 0));
                }
            } else {
                this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for name test: " + String.valueOf(child)));
            }
        }
    }

    private void createExpression(SimpleNode node, NAryQueryNode queryNode) {
        if (node.getId() != 102) {
            throw new IllegalArgumentException("node must be of type ComparisonExpr");
        }
        String opType = node.getValue();
        int type = 0;
        if (opType.equals(OP_EQ)) {
            type = 11;
        } else if (opType.equals(OP_SIGN_EQ)) {
            type = 12;
        } else if (opType.equals(OP_GT)) {
            type = 17;
        } else if (opType.equals(OP_SIGN_GT)) {
            type = 18;
        } else if (opType.equals(OP_GE)) {
            type = 19;
        } else if (opType.equals(OP_SIGN_GE)) {
            type = 20;
        } else if (opType.equals(OP_LE)) {
            type = 21;
        } else if (opType.equals(OP_SIGN_LE)) {
            type = 22;
        } else if (opType.equals(OP_LT)) {
            type = 15;
        } else if (opType.equals(OP_SIGN_LT)) {
            type = 16;
        } else if (opType.equals(OP_NE)) {
            type = 13;
        } else if (opType.equals(OP_SIGN_NE)) {
            type = 14;
        } else {
            this.exceptions.add((Exception)new InvalidQueryException("Unsupported ComparisonExpr type:" + node.getValue()));
        }
        final RelationQueryNode rqn = this.factory.createRelationQueryNode(queryNode, type);
        node.childrenAccept(this, rqn);
        try {
            rqn.acceptOperands(new DefaultQueryNodeVisitor(){

                @Override
                public Object visit(PropertyFunctionQueryNode node, Object data) {
                    String functionName = node.getFunctionName();
                    if ((functionName.equals("lower-case") || functionName.equals("upper-case")) && rqn.getValueType() != 3) {
                        String msg = "Upper and lower case function are only supported with String literals";
                        XPathQueryBuilder.this.exceptions.add((Exception)new InvalidQueryException(msg));
                    }
                    return data;
                }
            }, null);
        }
        catch (RepositoryException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        queryNode.addOperand(rqn);
    }

    private PathQueryNode createPathQueryNode(SimpleNode node) {
        this.root.setLocationNode(this.factory.createPathQueryNode(this.root));
        node.childrenAccept(this, this.root.getLocationNode());
        return this.root.getLocationNode();
    }

    private void assignValue(SimpleNode node, RelationQueryNode queryNode) {
        if (node.getId() == 47) {
            queryNode.setStringValue(this.unescapeQuotes(node.getValue()));
        } else if (node.getId() == 147) {
            queryNode.setDoubleValue(Double.parseDouble(node.getValue()));
        } else if (node.getId() == 148) {
            queryNode.setDoubleValue(Double.parseDouble(node.getValue()));
        } else if (node.getId() == 146) {
            if (queryNode.getValueType() == 6) {
                queryNode.setPositionValue(Integer.parseInt(node.getValue()));
            } else {
                queryNode.setLongValue(Long.parseLong(node.getValue()));
            }
        } else {
            this.exceptions.add((Exception)new InvalidQueryException("Unsupported literal type:" + node.toString()));
        }
    }

    private QueryNode createFunction(SimpleNode node, QueryNode queryNode) {
        block101: {
            String tmp = ((SimpleNode)node.jjtGetChild(0)).getValue();
            String fName = tmp.substring(0, tmp.length() - 1);
            try {
                InternalQName funName = this.resolver.parseJCRName(fName).getInternalName();
                if (FN_NOT.equals((Object)funName) || FN_NOT_10.equals((Object)funName)) {
                    if (queryNode instanceof NAryQueryNode) {
                        NotQueryNode not = this.factory.createNotQueryNode(queryNode);
                        ((NAryQueryNode)queryNode).addOperand(not);
                        queryNode = not;
                        if (node.jjtGetNumChildren() == 2) {
                            node.jjtGetChild(1).jjtAccept(this, queryNode);
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("fn:not only supports one expression argument"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for function fn:not"));
                    }
                    break block101;
                }
                if (XS_DATETIME.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 2) {
                        if (queryNode instanceof RelationQueryNode) {
                            RelationQueryNode rel = (RelationQueryNode)queryNode;
                            SimpleNode literal = (SimpleNode)node.jjtGetChild(1).jjtGetChild(0);
                            if (literal.getId() == 47) {
                                String value = literal.getValue();
                                Calendar c = ISO8601.parse((String)(value = value.substring(1, value.length() - 1)));
                                if (c == null) {
                                    this.exceptions.add((Exception)new InvalidQueryException("Unable to parse string literal for xs:dateTime: " + value));
                                } else {
                                    rel.setDateValue(c.getTime());
                                }
                            } else {
                                this.exceptions.add((Exception)new InvalidQueryException("Wrong argument type for xs:dateTime"));
                            }
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for function xs:dateTime"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of arguments for xs:dateTime"));
                    }
                    break block101;
                }
                if (JCR_CONTAINS.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 3) {
                        if (queryNode instanceof NAryQueryNode) {
                            SimpleNode literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0);
                            if (literal.getId() == 47) {
                                TextsearchQueryNode contains = this.factory.createTextsearchQueryNode(queryNode, this.unescapeQuotes(literal.getValue()));
                                SimpleNode path = (SimpleNode)node.jjtGetChild(1);
                                path.jjtAccept(this, contains);
                                ((NAryQueryNode)queryNode).addOperand(contains);
                            } else {
                                this.exceptions.add((Exception)new InvalidQueryException("Wrong argument type for jcr:contains"));
                            }
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of arguments for jcr:contains"));
                    }
                    break block101;
                }
                if (JCR_LIKE.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 3) {
                        if (queryNode instanceof NAryQueryNode) {
                            SimpleNode literal;
                            RelationQueryNode like = this.factory.createRelationQueryNode(queryNode, 23);
                            ((NAryQueryNode)queryNode).addOperand(like);
                            node.jjtGetChild(1).jjtAccept(this, like);
                            if (like.getRelativePath() == null) {
                                this.exceptions.add((Exception)new InvalidQueryException("Wrong first argument type for jcr:like"));
                            }
                            if ((literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0)).getId() == 47) {
                                like.setStringValue(this.unescapeQuotes(literal.getValue()));
                            } else {
                                this.exceptions.add((Exception)new InvalidQueryException("Wrong second argument type for jcr:like"));
                            }
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for function jcr:like"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of arguments for jcr:like"));
                    }
                    break block101;
                }
                if (FN_TRUE.equals((Object)funName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        rel.setStringValue("true");
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for true()"));
                    }
                    break block101;
                }
                if (FN_FALSE.equals((Object)funName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        rel.setStringValue("false");
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for false()"));
                    }
                    break block101;
                }
                if (FN_POSITION.equals((Object)funName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        if (rel.getOperation() == 12) {
                            rel.setPositionValue(1);
                            rel.addPathElement(new QPathEntry(FN_POSITION_FULL, 0));
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported expression with position(). Only = is supported."));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for position()"));
                    }
                    break block101;
                }
                if (FN_FIRST.equals((Object)funName)) {
                    if (queryNode.getType() == 2) {
                        ((RelationQueryNode)queryNode).setPositionValue(1);
                    } else if (queryNode.getType() == 10) {
                        ((LocationStepQueryNode)queryNode).setIndex(1);
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for first()"));
                    }
                    break block101;
                }
                if (FN_LAST.equals((Object)funName)) {
                    if (queryNode.getType() == 2) {
                        ((RelationQueryNode)queryNode).setPositionValue(Integer.MIN_VALUE);
                    } else if (queryNode.getType() == 10) {
                        ((LocationStepQueryNode)queryNode).setIndex(Integer.MIN_VALUE);
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for last()"));
                    }
                    break block101;
                }
                if (JCR_DEREF.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() != 3) break block101;
                    boolean descendant = false;
                    if (queryNode.getType() == 10) {
                        LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                        descendant = loc.getIncludeDescendants();
                        queryNode = loc.getParent();
                        ((NAryQueryNode)queryNode).removeOperand(loc);
                    }
                    if (queryNode.getType() == 11) {
                        SimpleNode literal;
                        PathQueryNode pathNode = (PathQueryNode)queryNode;
                        DerefQueryNode derefNode = this.factory.createDerefQueryNode(pathNode, null, false);
                        node.jjtGetChild(1).jjtAccept(this, derefNode);
                        if (derefNode.getRefProperty() == null) {
                            this.exceptions.add((Exception)new InvalidQueryException("Wrong first argument type for jcr:deref"));
                        }
                        if ((literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0)).getId() == 47) {
                            String value = literal.getValue();
                            if (!(value = value.substring(1, value.length() - 1)).equals("*")) {
                                InternalQName name = null;
                                try {
                                    name = XPathQueryBuilder.decode(this.resolver.parseJCRName(value).getInternalName());
                                }
                                catch (RepositoryException e) {
                                    this.exceptions.add((Exception)new InvalidQueryException("Illegal name: " + value));
                                }
                                derefNode.setNameTest(name);
                            }
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Second argument for jcr:deref must be a String"));
                        }
                        if (!descendant) {
                            SimpleNode c;
                            Node p = node.jjtGetParent();
                            for (int i = 0; i < p.jjtGetNumChildren() && (c = (SimpleNode)p.jjtGetChild(i)) != node; ++i) {
                                descendant = c.getId() == 122 || c.getId() == 121;
                            }
                        }
                        derefNode.setIncludeDescendants(descendant);
                        pathNode.addPathStep(derefNode);
                        break block101;
                    }
                    this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for jcr:deref()"));
                    break block101;
                }
                if (JCR_SCORE.equals((Object)funName)) {
                    if (queryNode.getType() == 3) {
                        this.createOrderSpec(node, (OrderQueryNode)queryNode);
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for jcr:score()"));
                    }
                } else if (FN_LOWER_CASE.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 2) {
                        if (queryNode.getType() == 2) {
                            RelationQueryNode relNode = (RelationQueryNode)queryNode;
                            relNode.addOperand(this.factory.createPropertyFunctionQueryNode(relNode, "lower-case"));
                            node.jjtGetChild(1).jjtAccept(this, relNode);
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for fn:lower-case()"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of argument for fn:lower-case()"));
                    }
                } else if (FN_UPPER_CASE.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 2) {
                        if (queryNode.getType() == 2) {
                            RelationQueryNode relNode = (RelationQueryNode)queryNode;
                            relNode.addOperand(this.factory.createPropertyFunctionQueryNode(relNode, "upper-case"));
                            node.jjtGetChild(1).jjtAccept(this, relNode);
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for fn:upper-case()"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for fn:upper-case()"));
                    }
                } else if (REP_SIMILAR.equals((Object)funName)) {
                    if (node.jjtGetNumChildren() == 3) {
                        if (queryNode instanceof NAryQueryNode) {
                            NAryQueryNode parent = (NAryQueryNode)queryNode;
                            RelationQueryNode rel = this.factory.createRelationQueryNode(parent, 28);
                            parent.addOperand(rel);
                            node.jjtGetChild(1).jjtAccept(this, rel);
                            node.jjtGetChild(2).jjtAccept(this, rel);
                            if (rel.getStringValue() == null) {
                                this.exceptions.add((Exception)new InvalidQueryException("Second argument for rep:similar() must be of type string"));
                            }
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for rep:similar()"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of arguments for rep:similar()"));
                    }
                } else if (REP_SPELLCHECK.equals((Object)funName) && queryNode.getType() != 11) {
                    if (node.jjtGetNumChildren() == 2) {
                        if (queryNode instanceof NAryQueryNode) {
                            NAryQueryNode parent = (NAryQueryNode)queryNode;
                            RelationQueryNode rel = this.factory.createRelationQueryNode(parent, 29);
                            parent.addOperand(rel);
                            node.jjtGetChild(1).jjtAccept(this, rel);
                            if (rel.getStringValue() == null) {
                                this.exceptions.add((Exception)new InvalidQueryException("Argument for rep:spellcheck() must be of type string"));
                            }
                            rel.addPathElement(new QPathEntry(Constants.JCR_PRIMARYTYPE, 0));
                        } else {
                            this.exceptions.add((Exception)new InvalidQueryException("Unsupported location for rep:spellcheck()"));
                        }
                    } else {
                        this.exceptions.add((Exception)new InvalidQueryException("Wrong number of arguments for rep:spellcheck()"));
                    }
                } else if (queryNode.getType() == 2) {
                    try {
                        InternalQName name = this.resolver.parseJCRName(fName + "()").getInternalName();
                        RelationQueryNode relNode = (RelationQueryNode)queryNode;
                        relNode.addPathElement(new QPathEntry(name, 0));
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add((Exception)((Object)e));
                    }
                } else if (queryNode.getType() == 11) {
                    try {
                        InternalQName name = this.resolver.parseJCRName(fName + "()").getInternalName();
                        this.root.addSelectProperty(name);
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add((Exception)((Object)e));
                    }
                } else {
                    this.exceptions.add((Exception)new InvalidQueryException("Unsupported function: " + fName));
                }
            }
            catch (NamespaceException e) {
                this.exceptions.add((Exception)((Object)e));
            }
            catch (RepositoryException e) {
                this.exceptions.add((Exception)((Object)e));
            }
        }
        return queryNode;
    }

    private OrderQueryNode.OrderSpec createOrderSpec(SimpleNode node, OrderQueryNode queryNode) {
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        OrderQueryNode.OrderSpec spec = null;
        try {
            String propName = child.getValue();
            if (child.getId() == 62) {
                propName = propName.substring(0, propName.length() - 1);
            }
            InternalQName name = XPathQueryBuilder.decode(this.resolver.parseJCRName(propName).getInternalName());
            QPath relPath = this.getRelativePath();
            QPath resultPath = null;
            resultPath = relPath != null ? QPath.makeChildPath(relPath, name) : new QPath(new QPathEntry[]{new QPathEntry(name, 1)});
            spec = new OrderQueryNode.OrderSpec(resultPath, true);
            queryNode.addOrderSpec(spec);
        }
        catch (RepositoryException e) {
            this.exceptions.add((Exception)new InvalidQueryException("Illegal name: " + child.getValue()));
        }
        return spec;
    }

    private boolean isAttributeAxis(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (((SimpleNode)node.jjtGetChild(i)).getId() != 131) continue;
            return true;
        }
        return false;
    }

    private boolean isAttributeNameTest(SimpleNode node) {
        SimpleNode stepExpr = (SimpleNode)node.jjtGetParent().jjtGetParent();
        if (stepExpr.getId() == 123) {
            return ((SimpleNode)stepExpr.jjtGetChild(0)).getId() == 131;
        }
        return false;
    }

    private String unescapeQuotes(String literal) {
        String value = literal.substring(1, literal.length() - 1);
        if (value.length() == 0) {
            return value;
        }
        value = literal.charAt(0) == '\"' ? value.replaceAll("\"\"", "\"") : value.replaceAll("''", "'");
        return value;
    }

    private static InternalQName decode(InternalQName name) {
        InternalQName decodedLN = ISO9075.decode(name);
        if (decodedLN.equals((Object)name)) {
            return name;
        }
        return new InternalQName(name.getNamespace(), decodedLN.getName());
    }
}

