/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class TransformAdapter2D
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = 7587206692912120654L;
    private final MathTransform impl;

    TransformAdapter2D(MathTransform mathTransform) {
        this.impl = mathTransform;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        Matrix matrix;
        Matrix matrix2 = matrix = bl ? this.impl.derivative((DirectPosition)new DirectPosition2D(dArray[n], dArray[n + 1])) : null;
        if (dArray2 != null) {
            this.impl.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.impl.transform(dArray, n, dArray2, n2, n3);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.impl.transform(dArray, n, fArray, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.impl.transform(fArray, n, dArray, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.impl.transform(fArray, n, fArray2, n2, n3);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        return this.impl.transform(directPosition, directPosition2);
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return MathTransforms.bidimensional(this.impl.inverse());
    }

    @Override
    public String toWKT() {
        return this.impl.toWKT();
    }
}

