/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;

public class PermissionValue
extends BaseValue {
    private static final int TYPE = 100;
    private String identity;
    private String permission;

    public PermissionValue(ValueData data) {
        super(100, data);
        try {
            AccessControlEntry accessEntry = ValueDataUtil.getPermission(data);
            this.identity = accessEntry.getIdentity();
            this.permission = accessEntry.getPermission();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("FATAL ERROR RepositoryException occured: " + e.getMessage(), e);
        }
    }

    public PermissionValue(String identity, String permission) throws IOException {
        super(100, new TransientValueData(new AccessControlEntry(identity, permission)));
        if (!(permission == null || permission.equals("read") || permission.equals("add_node") || permission.equals("remove") || permission.equals("set_property"))) {
            throw new RuntimeException("Permission should be one of defined in PermissionType. Have " + permission);
        }
        this.identity = identity;
        this.permission = permission;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getPermission() {
        return this.permission;
    }
}

