/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Set;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class PositionalConsistencyImage
extends SourceAlignedImage {
    private static final Set<String> INHERITED_PROPERTIES = JDK9.setOf((Object[])new String[]{"org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.Mask"});
    private static final String[] ADDED_PROPERTIES = new String[]{"org.apache.sis.SampleResolution"};
    private final MathTransform toSource;
    private final MathTransform toTarget;

    PositionalConsistencyImage(ResampledImage resampledImage, MathTransform mathTransform) throws TransformException {
        super(resampledImage, ColorModelFactory.createGrayScale(4, 1, 0, 0.0, 1.0));
        this.toSource = mathTransform;
        this.toTarget = resampledImage.toSource.inverse();
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "org.apache.sis.SampleResolution": {
                return new double[]{0.015625};
            }
            case "org.apache.sis.PositionalAccuracy": 
            case "org.apache.sis.GridGeometry": 
            case "org.apache.sis.Mask": {
                return this.getSource().getProperty(string);
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return PositionalConsistencyImage.filterPropertyNames(this.getSource().getPropertyNames(), INHERITED_PROPERTIES, ADDED_PROPERTIES);
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        if (writableRaster == null) {
            writableRaster = this.createTile(n, n2);
        }
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        int n6 = Math.addExact(n4, n3);
        int n7 = Math.addExact(n5, writableRaster.getHeight());
        double[] dArray = new double[n3 * Math.max(2, this.toSource.getSourceDimensions())];
        for (int i = n5; i < n7; ++i) {
            int n8;
            int n9 = 0;
            for (n8 = n4; n8 < n6; ++n8) {
                dArray[n9++] = n8;
                dArray[n9++] = i;
            }
            this.toSource.transform(dArray, 0, dArray, 0, n3);
            this.toTarget.transform(dArray, 0, dArray, 0, n3);
            n9 = 0;
            n8 = 0;
            for (int j = n4; j < n6; ++j) {
                dArray[n9++] = Math.hypot(dArray[n8++] - (double)j, dArray[n8++] - (double)i);
            }
            writableRaster.setSamples(n4, i, n3, 1, 0, dArray);
        }
        return writableRaster;
    }
}

