/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

public class DoubleField {
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final int STRING_DOUBLE_LEN = Long.toString(Long.MAX_VALUE, 36).length() + 1;

    private DoubleField() {
    }

    public static String doubleToString(double value) {
        long longValue = Double.doubleToLongBits(value);
        StringBuilder sb = new StringBuilder(STRING_DOUBLE_LEN);
        if ((longValue & Long.MIN_VALUE) == 0L) {
            String s = Long.toString(longValue, 36);
            sb.append('1');
            while (sb.length() + s.length() < STRING_DOUBLE_LEN) {
                sb.append('0');
            }
            sb.append(s);
        } else {
            longValue = -longValue;
            String s = Long.toString(longValue, 36);
            while (sb.length() + s.length() < STRING_DOUBLE_LEN) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static double stringToDouble(String value) {
        if (value.charAt(0) == '1') {
            long longValue = Long.parseLong(value.substring(1), 36);
            return Double.longBitsToDouble(longValue);
        }
        if (value.charAt(0) == '0') {
            long longValue = Long.parseLong(value, 36);
            longValue = -longValue;
            return Double.longBitsToDouble(longValue);
        }
        throw new IllegalArgumentException("not a valid string representation of a double: " + value);
    }
}

