/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.PlatformPass;

@XmlType(name="MI_PlatformPass_Type", propOrder={"identifier", "extent", "relatedEvents"})
@XmlRootElement(name="MI_PlatformPass")
public class DefaultPlatformPass
extends ISOMetadata
implements PlatformPass {
    private static final long serialVersionUID = -6447077434254133293L;
    private Geometry extent;
    private Collection<Event> relatedEvents;

    public DefaultPlatformPass() {
    }

    public DefaultPlatformPass(PlatformPass platformPass) {
        super(platformPass);
        if (platformPass != null) {
            this.identifiers = this.singleton(platformPass.getIdentifier(), Identifier.class);
            this.extent = platformPass.getExtent();
            this.relatedEvents = this.copyCollection(platformPass.getRelatedEvents(), Event.class);
        }
    }

    public static DefaultPlatformPass castOrCopy(PlatformPass platformPass) {
        if (platformPass == null || platformPass instanceof DefaultPlatformPass) {
            return (DefaultPlatformPass)platformPass;
        }
        return new DefaultPlatformPass(platformPass);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
    }

    @XmlElement(name="extent")
    public Geometry getExtent() {
        return this.extent;
    }

    public void setExtent(Geometry geometry) {
        this.checkWritePermission(this.extent);
        this.extent = geometry;
    }

    @XmlElement(name="relatedEvent")
    public Collection<Event> getRelatedEvents() {
        this.relatedEvents = this.nonNullCollection(this.relatedEvents, Event.class);
        return this.relatedEvents;
    }

    public void setRelatedEvents(Collection<? extends Event> collection) {
        this.relatedEvents = this.writeCollection(collection, this.relatedEvents, Event.class);
    }
}

