/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWithCRS;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.j2d.Factory;
import org.apache.sis.internal.feature.j2d.Wrapper;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.opengis.geometry.DirectPosition;

final class PointWrapper
extends GeometryWithCRS<Shape> {
    final Point2D point;
    private static final BiPredicate<PointWrapper, Object>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    PointWrapper(Point2D point2D) {
        this.point = point2D;
    }

    @Override
    public Geometries<Shape> factory() {
        return Factory.INSTANCE;
    }

    @Override
    public Object implementation() {
        return this.point;
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        GeneralEnvelope generalEnvelope = this.createEnvelope();
        double d = this.point.getX();
        double d2 = this.point.getY();
        generalEnvelope.setRange(0, d, d2);
        generalEnvelope.setRange(1, d, d2);
        return generalEnvelope;
    }

    @Override
    public DirectPosition getCentroid() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.point.getX(), this.point.getY());
    }

    @Override
    public double[] getPointCoordinates() {
        return new double[]{this.point.getX(), this.point.getY()};
    }

    @Override
    public double[] getAllCoordinates() {
        return this.getPointCoordinates();
    }

    @Override
    protected Shape mergePolylines(Iterator<?> iterator) {
        return Wrapper.mergePolylines(this.point, iterator);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName spatialOperatorName, GeometryWrapper<Shape> geometryWrapper) {
        BiPredicate<PointWrapper, Object> biPredicate;
        int n = spatialOperatorName.ordinal();
        if (n >= 0 && n < PREDICATES.length && (biPredicate = PREDICATES[n]) != null) {
            return biPredicate.test(this, geometryWrapper);
        }
        return super.predicateSameCRS(spatialOperatorName, geometryWrapper);
    }

    @Override
    protected Object operationSameCRS(SQLMM sQLMM, GeometryWrapper<Shape> geometryWrapper, Object object) {
        switch (sQLMM) {
            case ST_Dimension: 
            case ST_CoordDim: {
                return 2;
            }
            case ST_Is3D: 
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_Centroid: {
                return this.point.clone();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                if (this.point instanceof Point) {
                    Point point = (Point)this.point;
                    Rectangle rectangle = new Rectangle();
                    rectangle.x = point.x;
                    rectangle.y = point.y;
                    return rectangle;
                }
                if (this.point instanceof Point2D.Float) {
                    Point2D.Float float_ = (Point2D.Float)this.point;
                    Rectangle2D.Float float_2 = new Rectangle2D.Float();
                    float_2.x = float_.x;
                    float_2.y = float_.y;
                    return float_2;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double();
                double_.x = this.point.getX();
                double_.y = this.point.getY();
                return double_;
            }
            case ST_Overlaps: 
            case ST_Within: {
                return this.within(geometryWrapper);
            }
            case ST_Intersects: {
                return this.intersect(geometryWrapper);
            }
            case ST_Disjoint: {
                return !this.intersect(geometryWrapper);
            }
            case ST_Contains: 
            case ST_Equals: {
                return this.equal(geometryWrapper);
            }
        }
        return super.operationSameCRS(sQLMM, geometryWrapper, object);
    }

    private boolean equal(Object object) {
        if (object instanceof PointWrapper) {
            Point2D point2D = ((PointWrapper)object).point;
            return Double.doubleToLongBits(this.point.getX()) == Double.doubleToLongBits(point2D.getX()) && Double.doubleToLongBits(this.point.getY()) == Double.doubleToLongBits(point2D.getY());
        }
        return false;
    }

    private boolean within(Object object) {
        return object instanceof Wrapper && ((Wrapper)object).geometry.contains(this.point);
    }

    private boolean intersect(Object object) {
        if (object instanceof PointWrapper) {
            return this.point.equals(((PointWrapper)object).point);
        }
        return this.within(object);
    }

    @Override
    public String formatWKT(double d) {
        return this.getCentroid().toString();
    }

    static {
        BiPredicate<PointWrapper, Object> biPredicate = PointWrapper::intersect;
        PointWrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = biPredicate;
        PointWrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = PointWrapper::within;
        BiPredicate<PointWrapper, Object> biPredicate2 = PointWrapper::equal;
        PointWrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = biPredicate2;
        PointWrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = biPredicate2;
        PointWrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = (pointWrapper, object) -> !pointWrapper.intersect(object);
    }
}

