/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilInternationalString;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilObjectHandler;
import org.opengis.util.InternationalString;

public final class NilReason
implements Serializable {
    private static final long serialVersionUID = 5553785821187789895L;
    public static final NilReason INAPPLICABLE = new NilReason("inapplicable");
    public static final NilReason MISSING = new NilReason("missing");
    public static final NilReason TEMPLATE = new NilReason("template");
    public static final NilReason UNKNOWN = new NilReason("unknown");
    public static final NilReason WITHHELD = new NilReason("withheld");
    private static final String other = "other";
    public static final NilReason OTHER = new NilReason("other");
    private static final NilReason[] PREDEFINED = new NilReason[]{INAPPLICABLE, MISSING, TEMPLATE, UNKNOWN, WITHHELD, OTHER};
    private static final WeakHashSet<NilReason> POOL = new WeakHashSet(NilReason.class);
    private final Object reason;
    private transient InvocationHandler handler;
    private transient Map<Class<?>, Object> nilObjects;

    private NilReason(Object object) {
        this.reason = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NilReason[] values() {
        int n;
        NilReason[] nilReasonArray;
        int n2 = PREDEFINED.length;
        WeakHashSet<NilReason> weakHashSet = POOL;
        synchronized (weakHashSet) {
            nilReasonArray = (NilReason[])POOL.toArray((Object[])new NilReason[n2 + POOL.size()]);
        }
        for (n = nilReasonArray.length; n != 0 && nilReasonArray[n - 1] == null; --n) {
        }
        NilReason[] nilReasonArray2 = nilReasonArray;
        if ((n += n2) != nilReasonArray.length) {
            nilReasonArray = new NilReason[n];
        }
        System.arraycopy(nilReasonArray2, 0, nilReasonArray, n2, n - n2);
        System.arraycopy(PREDEFINED, 0, nilReasonArray, 0, n2);
        return nilReasonArray;
    }

    public static NilReason valueOf(String string) throws URISyntaxException {
        int n = (string = CharSequences.trimWhitespaces((String)string)).indexOf(58);
        if (n < 0) {
            for (NilReason nilReason : PREDEFINED) {
                if (!string.equalsIgnoreCase((String)nilReason.reason)) continue;
                return nilReason;
            }
        } else {
            int n2;
            int n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)0, (int)n);
            if (string.regionMatches(true, n3, other, 0, (n2 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n3, (int)n)) - n3)) {
                int n4 = string.length();
                StringBuilder stringBuilder = new StringBuilder(n4).append(other);
                while (n < n4) {
                    int n5 = string.codePointAt(n);
                    if (!Character.isSpaceChar(n5) && !Character.isISOControl(n5)) {
                        stringBuilder.appendCodePoint(n5);
                    }
                    n += Character.charCount(n5);
                }
                if (stringBuilder.length() < other.length() + 2) {
                    return OTHER;
                }
                String string2 = stringBuilder.toString();
                if (string2.equals(string)) {
                    string2 = string;
                }
                return (NilReason)POOL.unique((Object)new NilReason(string2));
            }
        }
        return (NilReason)POOL.unique((Object)new NilReason(new URI(string)));
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.reason instanceof String) {
            for (NilReason nilReason : PREDEFINED) {
                if (!this.reason.equals(nilReason.reason)) continue;
                return nilReason;
            }
        }
        return POOL.unique((Object)this);
    }

    public String getOtherExplanation() {
        if (this.reason instanceof String) {
            String string = (String)this.reason;
            int n = string.indexOf(58);
            if (n >= 0) {
                return string.substring(n + 1);
            }
            if (string.equals(other)) {
                return "";
            }
        }
        return null;
    }

    public URI getURI() {
        return this.reason instanceof URI ? (URI)this.reason : null;
    }

    public String toString() {
        return this.reason.toString();
    }

    public int hashCode() {
        return this.reason.hashCode() ^ 0x767FD447;
    }

    public boolean equals(Object object) {
        if (object instanceof NilReason) {
            return this.reason.equals(((NilReason)object).reason);
        }
        return false;
    }

    public synchronized <T> T createNilObject(Class<T> clazz) {
        Object object;
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        if (this.nilObjects == null) {
            this.nilObjects = new WeakValueHashMap(Class.class);
        }
        if ((object = this.nilObjects.get(clazz)) == null) {
            if (clazz.isInterface()) {
                if (NilObjectHandler.isIgnoredInterface(clazz)) {
                    throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", clazz));
                }
                if (clazz == InternationalString.class) {
                    object = new NilInternationalString(this);
                } else {
                    if (this.handler == null) {
                        this.handler = new NilObjectHandler(this);
                    }
                    object = Proxy.newProxyInstance(NilReason.class.getClassLoader(), new Class[]{clazz, NilObject.class, LenientComparable.class}, this.handler);
                }
            } else {
                object = NilReason.createNilPrimitive(clazz);
                PrimitiveTypeProperties.associate(object, this);
            }
            if (this.nilObjects.put(clazz, object) != null) {
                throw new AssertionError(clazz);
            }
        }
        return clazz.cast(object);
    }

    private static Object createNilPrimitive(Class<?> clazz) {
        if (clazz == String.class) {
            return new String("");
        }
        if (clazz == Boolean.class) {
            return new Boolean(false);
        }
        if (clazz == Byte.class) {
            return new Byte(0);
        }
        if (clazz == Short.class) {
            return new Short(0);
        }
        if (clazz == Integer.class) {
            return new Integer(0);
        }
        if (clazz == Long.class) {
            return new Long(0L);
        }
        if (clazz == Float.class) {
            return new Float(Float.NaN);
        }
        if (clazz == Double.class) {
            return new Double(Double.NaN);
        }
        throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", clazz));
    }

    private static boolean mayBeNil(Object object) {
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false && object != Boolean.FALSE;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 0;
        }
        return false;
    }

    public static NilReason forObject(Object object) {
        if (object != null) {
            if (object instanceof NilObject) {
                return ((NilObject)object).getNilReason();
            }
            if (NilReason.mayBeNil(object)) {
                return (NilReason)PrimitiveTypeProperties.property(object);
            }
        }
        return null;
    }
}

