/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractItemDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeReadException;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;

public class PropertyDefinitionAccessProvider
extends AbstractItemDefinitionAccessProvider {
    public PropertyDefinitionAccessProvider(DataManager dataManager) {
        super(dataManager);
    }

    public PropertyDefinitionData read(NodeData nodeData, InternalQName declaringNodeType) throws NodeTypeReadException, RepositoryException {
        if (Constants.NT_PROPERTYDEFINITION.equals((Object)nodeData.getPrimaryTypeName())) {
            InternalQName name = this.readName(nodeData, null, Constants.JCR_NAME);
            boolean protectedItem = this.readMandatoryBoolean(nodeData, null, Constants.JCR_PROTECTED);
            boolean autoCreated = this.readMandatoryBoolean(nodeData, null, Constants.JCR_AUTOCREATED);
            boolean mandatory = this.readMandatoryBoolean(nodeData, null, Constants.JCR_MANDATORY);
            int onParentVersion = OnParentVersionAction.valueFromName((String)this.readMandatoryString(nodeData, Constants.JCR_ONPARENTVERSION));
            int requiredType = ExtendedPropertyType.valueFromName(this.readMandatoryString(nodeData, Constants.JCR_REQUIREDTYPE));
            boolean multiple = this.readMandatoryBoolean(nodeData, null, Constants.JCR_MULTIPLE);
            String[] valueConstraints = this.readStrings(nodeData, null, Constants.JCR_VALUECONSTRAINTS);
            String[] defaultValues = this.readStrings(nodeData, null, Constants.JCR_DEFAULTVALUES);
            return new PropertyDefinitionData(name, declaringNodeType, autoCreated, mandatory, onParentVersion, protectedItem, requiredType, valueConstraints, defaultValues, multiple);
        }
        return null;
    }

    public PropertyDefinitionData read(NodeData nodeData, List<PropertyData> props, InternalQName declaringNodeType) throws NodeTypeReadException, RepositoryException {
        HashMap<InternalQName, PropertyData> mapProps = new HashMap<InternalQName, PropertyData>();
        for (PropertyData propertyData : props) {
            mapProps.put(propertyData.getQPath().getName(), propertyData);
        }
        if (Constants.NT_PROPERTYDEFINITION.equals((Object)nodeData.getPrimaryTypeName())) {
            InternalQName name = this.readName(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_NAME), Constants.JCR_NAME);
            boolean protectedItem = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_PROTECTED), Constants.JCR_PROTECTED);
            boolean autoCreated = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_AUTOCREATED), Constants.JCR_AUTOCREATED);
            boolean mandatory = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_MANDATORY), Constants.JCR_MANDATORY);
            int onParentVersion = OnParentVersionAction.valueFromName((String)this.readMandatoryString(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_ONPARENTVERSION), Constants.JCR_ONPARENTVERSION));
            int requiredType = ExtendedPropertyType.valueFromName(this.readMandatoryString(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_REQUIREDTYPE), Constants.JCR_REQUIREDTYPE));
            boolean multiple = this.readMandatoryBoolean(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_MULTIPLE), Constants.JCR_MULTIPLE);
            String[] valueConstraints = this.readStrings(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_VALUECONSTRAINTS), Constants.JCR_VALUECONSTRAINTS);
            String[] defaultValues = this.readStrings(nodeData, (PropertyData)mapProps.get((Object)Constants.JCR_DEFAULTVALUES), Constants.JCR_DEFAULTVALUES);
            return new PropertyDefinitionData(name, declaringNodeType, autoCreated, mandatory, onParentVersion, protectedItem, requiredType, valueConstraints, defaultValues, multiple);
        }
        return null;
    }

    public void write(PlainChangesLog changesLog, NodeData declaredNodeType, PropertyDefinitionData propertyDefinitionData, int index) {
        TransientNodeData propertyDefinition = TransientNodeData.createNodeData(declaredNodeType, Constants.JCR_PROPERTYDEFINITION, Constants.NT_PROPERTYDEFINITION, index);
        changesLog.add(ItemState.createAddedState(propertyDefinition));
        this.writeItemDefinition(changesLog, propertyDefinition, propertyDefinitionData);
        this.writeName(changesLog, propertyDefinition, Constants.JCR_PRIMARYTYPE, propertyDefinition.getPrimaryTypeName());
        this.writeString(changesLog, propertyDefinition, Constants.JCR_REQUIREDTYPE, ExtendedPropertyType.nameFromValue(propertyDefinitionData.getRequiredType()));
        this.writeBoolean(changesLog, propertyDefinition, Constants.JCR_MULTIPLE, propertyDefinitionData.isMultiple());
        if (propertyDefinitionData.getValueConstraints() != null && propertyDefinitionData.getValueConstraints().length != 0) {
            this.writeStrings(changesLog, propertyDefinition, Constants.JCR_VALUECONSTRAINTS, propertyDefinitionData.getValueConstraints());
        }
        if (propertyDefinitionData.getDefaultValues() != null && propertyDefinitionData.getDefaultValues().length != 0) {
            this.writeStrings(changesLog, propertyDefinition, Constants.JCR_DEFAULTVALUES, propertyDefinitionData.getDefaultValues());
        }
    }
}

