/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.MD_Releasability;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.constraint.DefaultReleasability;
import org.apache.sis.metadata.iso.constraint.DefaultSecurityConstraints;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.quality.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Constraints_Type", propOrder={"useLimitations", "constraintApplicationScope", "graphic", "reference", "releasability", "responsibleParty"})
@XmlRootElement(name="MD_Constraints")
@XmlSeeAlso(value={DefaultLegalConstraints.class, DefaultSecurityConstraints.class})
public class DefaultConstraints
extends ISOMetadata
implements Constraints {
    private static final long serialVersionUID = -5622398793237824161L;
    private Collection<InternationalString> useLimitations;
    private Scope constraintApplicationScope;
    private Collection<BrowseGraphic> graphics;
    private Collection<Citation> references;
    private DefaultReleasability releasability;
    private Collection<DefaultResponsibility> responsibleParties;

    public DefaultConstraints() {
    }

    public DefaultConstraints(CharSequence charSequence) {
        this.useLimitations = this.singleton(Types.toInternationalString(charSequence), InternationalString.class);
    }

    public DefaultConstraints(Constraints constraints) {
        super(constraints);
        if (constraints != null) {
            this.useLimitations = this.copyCollection(constraints.getUseLimitations(), InternationalString.class);
            if (constraints instanceof DefaultConstraints) {
                DefaultConstraints defaultConstraints = (DefaultConstraints)constraints;
                this.constraintApplicationScope = defaultConstraints.getConstraintApplicationScope();
                this.graphics = this.copyCollection(defaultConstraints.getGraphics(), BrowseGraphic.class);
                this.references = this.copyCollection(defaultConstraints.getReferences(), Citation.class);
                this.releasability = defaultConstraints.getReleasability();
                this.responsibleParties = this.copyCollection(defaultConstraints.getResponsibleParties(), DefaultResponsibility.class);
            }
        }
    }

    public static DefaultConstraints castOrCopy(Constraints constraints) {
        if (constraints instanceof LegalConstraints) {
            return DefaultLegalConstraints.castOrCopy((LegalConstraints)constraints);
        }
        if (constraints instanceof SecurityConstraints) {
            return DefaultSecurityConstraints.castOrCopy((SecurityConstraints)constraints);
        }
        if (constraints == null || constraints instanceof DefaultConstraints) {
            return (DefaultConstraints)constraints;
        }
        return new DefaultConstraints(constraints);
    }

    @XmlElement(name="useLimitation")
    public Collection<InternationalString> getUseLimitations() {
        this.useLimitations = this.nonNullCollection(this.useLimitations, InternationalString.class);
        return this.useLimitations;
    }

    public void setUseLimitations(Collection<? extends InternationalString> collection) {
        this.useLimitations = this.writeCollection(collection, this.useLimitations, InternationalString.class);
    }

    @XmlElement(name="constraintApplicationScope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="constraintApplicationScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getConstraintApplicationScope() {
        return this.constraintApplicationScope;
    }

    public void setConstraintApplicationScope(Scope scope) {
        this.checkWritePermission(this.constraintApplicationScope);
        this.constraintApplicationScope = scope;
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> collection) {
        this.graphics = this.writeCollection(collection, this.graphics, BrowseGraphic.class);
    }

    @UML(identifier="reference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getReferences() {
        this.references = this.nonNullCollection(this.references, Citation.class);
        return this.references;
    }

    public void setReferences(Collection<? extends Citation> collection) {
        this.references = this.writeCollection(collection, this.references, Citation.class);
    }

    @XmlElement(name="releasability")
    @XmlJavaTypeAdapter(value=MD_Releasability.Since2014.class)
    @UML(identifier="releasability", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultReleasability getReleasability() {
        return this.releasability;
    }

    public void setReleasability(DefaultReleasability defaultReleasability) {
        this.checkWritePermission(this.releasability);
        this.releasability = defaultReleasability;
    }

    @UML(identifier="responsibleParty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultResponsibility> getResponsibleParties() {
        this.responsibleParties = this.nonNullCollection(this.responsibleParties, DefaultResponsibility.class);
        return this.responsibleParties;
    }

    public void setResponsibleParties(Collection<? extends DefaultResponsibility> collection) {
        this.responsibleParties = this.writeCollection(collection, this.responsibleParties, DefaultResponsibility.class);
    }

    @XmlElement(name="graphic")
    private Collection<BrowseGraphic> getGraphic() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getGraphics() : null;
    }

    @XmlElement(name="reference")
    private Collection<Citation> getReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getReferences() : null;
    }

    @XmlElement(name="responsibleParty")
    private Collection<DefaultResponsibility> getResponsibleParty() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResponsibleParties() : null;
    }
}

