/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.RelationshipBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.PropertyMapImpl;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DatabaseBuilder {
    private Path _mdbFile;
    private boolean _readOnly;
    private boolean _autoSync = true;
    private Charset _charset;
    private TimeZone _timeZone;
    private CodecProvider _codecProvider;
    private Database.FileFormat _fileFormat;
    private FileChannel _channel;
    private Map<String, PropertyMap.Property> _dbProps;
    private Map<String, PropertyMap.Property> _summaryProps;
    private Map<String, PropertyMap.Property> _userProps;

    public DatabaseBuilder() {
        this((Path)null);
    }

    public DatabaseBuilder(File mdbFile) {
        this(DatabaseBuilder.toPath(mdbFile));
    }

    public DatabaseBuilder(Path mdbFile) {
        this._mdbFile = mdbFile;
    }

    public DatabaseBuilder setFile(File mdbFile) {
        return this.setPath(DatabaseBuilder.toPath(mdbFile));
    }

    public DatabaseBuilder setPath(Path mdbFile) {
        this._mdbFile = mdbFile;
        return this;
    }

    public DatabaseBuilder setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
        return this;
    }

    public DatabaseBuilder setAutoSync(boolean autoSync) {
        this._autoSync = autoSync;
        return this;
    }

    public DatabaseBuilder setCharset(Charset charset) {
        this._charset = charset;
        return this;
    }

    public DatabaseBuilder setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        return this;
    }

    public DatabaseBuilder setCodecProvider(CodecProvider codecProvider) {
        this._codecProvider = codecProvider;
        return this;
    }

    public DatabaseBuilder setFileFormat(Database.FileFormat fileFormat) {
        this._fileFormat = fileFormat;
        return this;
    }

    public DatabaseBuilder setChannel(FileChannel channel) {
        this._channel = channel;
        return this;
    }

    public DatabaseBuilder putDatabaseProperty(String name, Object value) {
        return this.putDatabaseProperty(name, null, value);
    }

    public DatabaseBuilder putDatabaseProperty(String name, DataType type, Object value) {
        this._dbProps = DatabaseBuilder.putProperty(this._dbProps, name, type, value);
        return this;
    }

    public DatabaseBuilder putSummaryProperty(String name, Object value) {
        return this.putSummaryProperty(name, null, value);
    }

    public DatabaseBuilder putSummaryProperty(String name, DataType type, Object value) {
        this._summaryProps = DatabaseBuilder.putProperty(this._summaryProps, name, type, value);
        return this;
    }

    public DatabaseBuilder putUserDefinedProperty(String name, Object value) {
        return this.putUserDefinedProperty(name, null, value);
    }

    public DatabaseBuilder putUserDefinedProperty(String name, DataType type, Object value) {
        this._userProps = DatabaseBuilder.putProperty(this._userProps, name, type, value);
        return this;
    }

    private static Map<String, PropertyMap.Property> putProperty(Map<String, PropertyMap.Property> props, String name, DataType type, Object value) {
        if (props == null) {
            props = new HashMap<String, PropertyMap.Property>();
        }
        props.put(name, PropertyMapImpl.createProperty(name, type, value));
        return props;
    }

    public Database open() throws IOException {
        return DatabaseImpl.open(this._mdbFile, this._readOnly, this._channel, this._autoSync, this._charset, this._timeZone, this._codecProvider);
    }

    public Database create() throws IOException {
        PropertyMap props;
        DatabaseImpl db = DatabaseImpl.create(this._fileFormat, this._mdbFile, this._channel, this._autoSync, this._charset, this._timeZone);
        if (this._dbProps != null) {
            props = db.getDatabaseProperties();
            props.putAll(this._dbProps.values());
            props.save();
        }
        if (this._summaryProps != null) {
            props = db.getSummaryProperties();
            props.putAll(this._summaryProps.values());
            props.save();
        }
        if (this._userProps != null) {
            props = db.getUserDefinedProperties();
            props.putAll(this._userProps.values());
            props.save();
        }
        return db;
    }

    public static Database open(File mdbFile) throws IOException {
        return new DatabaseBuilder(mdbFile).open();
    }

    public static Database open(Path mdbFile) throws IOException {
        return new DatabaseBuilder(mdbFile).open();
    }

    public static Database create(Database.FileFormat fileFormat, File mdbFile) throws IOException {
        return new DatabaseBuilder(mdbFile).setFileFormat(fileFormat).create();
    }

    public static SimpleDateFormat createDateFormat(String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        DatabaseBuilder.toCompatibleCalendar(sdf.getCalendar());
        return sdf;
    }

    public static Calendar toCompatibleCalendar(Calendar cal) {
        if (cal instanceof GregorianCalendar) {
            ((GregorianCalendar)cal).setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return cal;
    }

    public static DatabaseBuilder newDatabase() {
        return new DatabaseBuilder();
    }

    public static DatabaseBuilder newDatabase(Path path) {
        return new DatabaseBuilder(path);
    }

    public static DatabaseBuilder newDatabase(File file) {
        return new DatabaseBuilder(file);
    }

    public static TableBuilder newTable(String name) {
        return new TableBuilder(name);
    }

    public static TableBuilder newTable(String name, boolean escapeIdentifiers) {
        return new TableBuilder(name, escapeIdentifiers);
    }

    public static ColumnBuilder newColumn(String name) {
        return new ColumnBuilder(name);
    }

    public static ColumnBuilder newColumn(String name, DataType type) {
        return new ColumnBuilder(name, type);
    }

    public static IndexBuilder newIndex(String name) {
        return new IndexBuilder(name);
    }

    public static IndexBuilder newPrimaryKey(String ... colNames) {
        return new IndexBuilder("PrimaryKey").addColumns(colNames).setPrimaryKey();
    }

    public static RelationshipBuilder newRelationship(String fromTable, String toTable) {
        return new RelationshipBuilder(fromTable, toTable);
    }

    public static RelationshipBuilder newRelationship(Table fromTable, Table toTable) {
        return new RelationshipBuilder(fromTable, toTable);
    }

    private static Path toPath(File file) {
        return file != null ? file.toPath() : null;
    }
}

