/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class DataElementPackage
extends StreamObject {
    public List<DataElement> dataElements = new ArrayList<DataElement>();
    public byte reserved;

    public DataElementPackage() {
        super(StreamObjectTypeHeaderStart.DataElementPackage);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        if (lengthOfItems != 1) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "DataElementPackage", "Stream object over-parse error", null);
        }
        this.reserved = byteArray[currentIndex.getAndIncrement()];
        this.dataElements = new ArrayList<DataElement>();
        AtomicReference dataElement = new AtomicReference();
        while (StreamObject.tryGetCurrent(byteArray, currentIndex, dataElement, DataElement.class)) {
            this.dataElements.add((DataElement)dataElement.get());
        }
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        byteList.add((byte)0);
        for (DataElement dataElement : this.dataElements) {
            byteList.addAll(dataElement.serializeToByteList());
        }
        return 1;
    }
}

