/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class WildcardMatchOnNameFilter
implements CrawlableDatasetFilter {
    protected String wildcardString;
    protected Pattern pattern;

    public WildcardMatchOnNameFilter(String wildcardString) {
        this.wildcardString = wildcardString;
        String regExp = this.mapWildcardToRegExp(wildcardString);
        this.pattern = Pattern.compile(regExp);
    }

    private String mapWildcardToRegExp(String wildcardString) {
        wildcardString = wildcardString.replaceAll("\\.", "\\\\.");
        wildcardString = wildcardString.replaceAll("\\*", ".*");
        wildcardString = wildcardString.replaceAll("\\?", ".?");
        return wildcardString;
    }

    @Override
    public Object getConfigObject() {
        return this.wildcardString;
    }

    public String getWildcardString() {
        return this.wildcardString;
    }

    @Override
    public boolean accept(CrawlableDataset dataset) {
        Matcher matcher = this.pattern.matcher(dataset.getName());
        return matcher.matches();
    }
}

