/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.PropertySingleton;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.resources.Errors;

abstract class Field<V>
extends Property {
    Field() {
    }

    static boolean isSingleton(int n) {
        return n <= 1;
    }

    public abstract V getValue() throws IllegalStateException;

    public Collection<V> getValues() {
        return new PropertySingleton(this);
    }

    public abstract void setValue(V var1);

    public void setValues(Collection<? extends V> collection) throws IllegalArgumentException {
        V v = null;
        ArgumentChecks.ensureNonNull((String)"values", collection);
        Iterator<V> iterator = collection.iterator();
        if (iterator.hasNext()) {
            v = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException(Errors.format((short)130, (Object)1, (Object)this.getName()));
            }
        }
        this.setValue(v);
    }

    static boolean isDeprecated(AbstractIdentifiedType abstractIdentifiedType) {
        return abstractIdentifiedType instanceof Deprecable && abstractIdentifiedType.isDeprecated();
    }
}

