/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.chain.web.MapEntry;

public class ParameterMap<P, T>
implements Map<String, T> {
    private final P parameter;
    private final Function<String, T> valueFunction;
    private final Supplier<Enumeration<String>> namesSupplier;

    public ParameterMap(P parameter, Function<String, T> valueFunction, Supplier<Enumeration<String>> namesSupplier) {
        this.parameter = parameter;
        this.valueFunction = valueFunction;
        this.namesSupplier = namesSupplier;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueFunction.apply(ParameterMap.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Enumeration<String> keys = this.namesSupplier.get();
        while (keys.hasMoreElements()) {
            T next = this.valueFunction.apply(keys.nextElement());
            if (!value.equals(next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.entrySet(false);
    }

    @Override
    public T get(Object key) {
        return this.valueFunction.apply(ParameterMap.key(key));
    }

    @Override
    public boolean isEmpty() {
        return !this.namesSupplier.get().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration<String> keys = this.namesSupplier.get();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    @Override
    public T put(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration<String> keys = this.namesSupplier.get();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> list = new ArrayList<T>();
        Enumeration<String> keys = this.namesSupplier.get();
        while (keys.hasMoreElements()) {
            list.add(this.valueFunction.apply(keys.nextElement()));
        }
        return list;
    }

    @Override
    public int hashCode() {
        return this.getParameter().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterMap other = (ParameterMap)obj;
        return Objects.equals(this.getParameter(), other.getParameter());
    }

    public String toString() {
        Iterator<Map.Entry<String, T>> entries = this.entrySet().iterator();
        if (entries.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<String, T> entrie = entries.next();
            String key = entrie.getKey();
            T value = entrie.getValue();
            sb.append(key).append('=').append(value);
            if (!entries.hasNext()) break;
            sb.append(',').append(' ');
        }
        return sb.append('}').toString();
    }

    protected P getParameter() {
        return this.parameter;
    }

    protected Function<String, T> getValueFunction() {
        return this.valueFunction;
    }

    protected Supplier<Enumeration<String>> getNamesSupplier() {
        return this.namesSupplier;
    }

    protected Set<Map.Entry<String, T>> entrySet(boolean modifiable) {
        HashSet<Map.Entry<String, T>> set = new HashSet<Map.Entry<String, T>>();
        Enumeration<String> keys = this.namesSupplier.get();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            set.add(new MapEntry<T>(key, this.valueFunction.apply(key), modifiable));
        }
        return set;
    }

    protected static String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

