/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.xml.Namespaces;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;
import org.apache.sis.xml.Transformer;

final class TransformingReader
extends Transformer
implements XMLEventReader {
    static final String FILENAME = "RenameOnImport.lst";
    private static final Set<String> LEGACY_NAMESPACES = new HashSet<String>(12);
    private static final Map<String, Map<String, String>> NAMESPACES = TransformingReader.load(false, "RenameOnImport.lst", LEGACY_NAMESPACES, 260);
    private final XMLEventReader in;
    private final Map<String, String> prefixes;
    private XMLEvent nextEvent;

    static String namespace(String string) {
        Map<String, String> map = NAMESPACES.get(string);
        return map != null ? map.get(string) : null;
    }

    TransformingReader(XMLEventReader xMLEventReader, TransformVersion transformVersion) {
        super(transformVersion);
        this.in = xMLEventReader;
        this.prefixes = new HashMap<String, String>();
    }

    private static boolean isWrapper(XMLEvent xMLEvent, XMLEvent xMLEvent2) {
        return xMLEvent == xMLEvent2 || xMLEvent2 instanceof TransformedEvent && ((TransformedEvent)xMLEvent2).event == xMLEvent;
    }

    @Override
    public boolean hasNext() {
        return this.nextEvent != null || this.in.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent xMLEvent;
        if (this.nextEvent == null && (xMLEvent = this.in.peek()) != null) {
            this.nextEvent = this.convert(xMLEvent);
        }
        return this.nextEvent;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new BackingStoreException((Throwable)xMLStreamException);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent = this.in.nextEvent();
        XMLEvent xMLEvent2 = this.nextEvent;
        if (xMLEvent2 != null) {
            this.nextEvent = null;
            assert (TransformingReader.isWrapper(xMLEvent, xMLEvent2)) : xMLEvent;
            return xMLEvent2;
        }
        return this.convert(xMLEvent);
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent xMLEvent = this.in.nextTag();
        XMLEvent xMLEvent2 = this.nextEvent;
        if (xMLEvent2 != null) {
            this.nextEvent = null;
            switch (xMLEvent.getEventType()) {
                case 1: 
                case 2: {
                    assert (TransformingReader.isWrapper(xMLEvent, xMLEvent2)) : xMLEvent;
                    return xMLEvent;
                }
            }
        }
        return this.convert(xMLEvent);
    }

    private XMLEvent convert(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 10: {
                xMLEvent = this.convert((Attribute)xMLEvent);
                break;
            }
            case 13: {
                xMLEvent = this.importNS((Namespace)xMLEvent, null, null);
                break;
            }
            case 1: {
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this.open(qName);
                QName qName2 = this.convert(qName);
                boolean bl = qName2 != qName;
                Namespace namespace = null;
                List<Object> list = startElement.getAttributes();
                while (list.hasNext()) {
                    Attribute attribute = list.next();
                    Attribute attribute2 = this.convert(attribute);
                    this.renamedAttributes.add(attribute2);
                    if (attribute == attribute2) continue;
                    bl = true;
                    if (namespace != null || !(attribute2 instanceof TransformedEvent.Type)) continue;
                    namespace = ((TransformedEvent.Type)attribute2).namespace;
                }
                list = this.importNS(startElement.getNamespaces(), qName.getNamespaceURI(), qName2.getNamespaceURI(), bl);
                if (list != null) {
                    if (namespace != null) {
                        if (list.isEmpty()) {
                            list = Collections.singletonList(namespace);
                        } else {
                            list.add(namespace);
                        }
                    }
                    xMLEvent = new TransformedEvent.Start(startElement, qName2, list, this.attributes(), this.version);
                    break;
                }
                this.renamedAttributes.clear();
                break;
            }
            case 2: {
                EndElement endElement = xMLEvent.asEndElement();
                QName qName = endElement.getName();
                QName qName3 = this.convert(qName);
                List<Namespace> list = this.importNS(endElement.getNamespaces(), qName.getNamespaceURI(), qName3.getNamespaceURI(), qName3 != qName);
                if (list != null) {
                    xMLEvent = new TransformedEvent.End(endElement, qName3, list);
                }
                this.close(qName);
                break;
            }
        }
        return xMLEvent;
    }

    @Override
    final Map<String, Map<String, String>> renamingMap(String string) {
        if (!string.isEmpty() && LEGACY_NAMESPACES.contains(TransformingReader.removeTrailingSlash(string))) {
            return NAMESPACES;
        }
        return Collections.emptyMap();
    }

    @Override
    final String relocate(String string) {
        return this.version.importNS(string);
    }

    @Override
    final String prefixReplacement(String string, String string3) {
        return this.prefixes.computeIfAbsent(string3, string2 -> Namespaces.getPreferredPrefix(string2, string));
    }

    private Namespace importNS(Namespace namespace, String string, String string2) {
        this.notify(namespace);
        String string3 = namespace.getNamespaceURI();
        if (string3 != null && !string3.isEmpty()) {
            String string4;
            String string5 = string4 = (string3 = TransformingReader.removeTrailingSlash(string3)).equals(string) ? string2 : this.relocate(string3);
            if (string4 != string3) {
                String string6 = this.prefixReplacement(namespace.getPrefix(), string4);
                return new TransformedEvent.NS(namespace, string6, string4);
            }
        }
        return namespace;
    }

    private List<Namespace> importNS(Iterator<Namespace> iterator, String string, String string2, boolean bl) {
        if (!iterator.hasNext()) {
            return bl ? Collections.emptyList() : null;
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        do {
            Namespace namespace;
            bl |= (namespace = iterator.next()) != (namespace = this.importNS(namespace, string, string2));
            arrayList.add(namespace);
        } while (iterator.hasNext());
        return bl ? arrayList : null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.in.getElementText();
    }

    @Override
    public Object getProperty(String string) {
        return this.in.getProperty(string);
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
        this.in.close();
    }
}

