/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CopyCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.CopyCommand");
    private final UriBuilder uriBuilder;
    private final boolean itemExisted;

    public CopyCommand() {
        this.uriBuilder = null;
        this.itemExisted = false;
    }

    public CopyCommand(UriBuilder uriBuilder, boolean itemExisted) {
        this.uriBuilder = uriBuilder;
        this.itemExisted = itemExisted;
    }

    public Response copy(Session destSession, String sourcePath, String destPath) {
        try {
            Workspace workspace = destSession.getWorkspace();
            workspace.copy(sourcePath, destPath);
            if (this.itemExisted) {
                return Response.noContent().build();
            }
            if (this.uriBuilder != null) {
                return Response.created((URI)this.uriBuilder.path(workspace.getName()).path(destPath).build(new Object[0])).build();
            }
            return Response.status((int)201).build();
        }
        catch (ItemExistsException e) {
            return Response.status((int)405).entity((Object)e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)409).entity((Object)e.getMessage()).build();
        }
        catch (AccessDeniedException e) {
            return Response.status((int)403).entity((Object)e.getMessage()).build();
        }
        catch (LockException e) {
            return Response.status((int)423).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    public Response copy(Session destSession, String sourceWorkspace, String sourcePath, String destPath) {
        try {
            Workspace destWorkspace = destSession.getWorkspace();
            destWorkspace.copy(sourceWorkspace, sourcePath, destPath);
            if (this.itemExisted) {
                return Response.noContent().build();
            }
            if (this.uriBuilder != null) {
                return Response.created((URI)this.uriBuilder.path(destWorkspace.getName()).path(destPath).build(new Object[0])).build();
            }
            return Response.status((int)201).build();
        }
        catch (ItemExistsException e) {
            return Response.status((int)405).entity((Object)e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)409).entity((Object)e.getMessage()).build();
        }
        catch (AccessDeniedException e) {
            return Response.status((int)403).entity((Object)e.getMessage()).build();
        }
        catch (LockException e) {
            return Response.status((int)423).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

