/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IndexerIoModeHandler {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerIoModeHandler");
    private volatile IndexerIoMode mode;
    private final List<IndexerIoModeListener> listeners;

    public IndexerIoModeHandler(IndexerIoMode mode) {
        log.info((Object)("Indexer io mode=" + String.valueOf((Object)mode)));
        this.mode = mode;
        this.listeners = new CopyOnWriteArrayList<IndexerIoModeListener>();
    }

    public IndexerIoMode getMode() {
        return this.mode;
    }

    public synchronized void setMode(IndexerIoMode mode) {
        if (this.mode != mode) {
            log.info((Object)("Indexer io mode=" + String.valueOf((Object)mode)));
            this.mode = mode;
            for (IndexerIoModeListener listener : this.listeners) {
                listener.onChangeMode(mode);
            }
        }
    }

    public void addIndexerIoModeListener(IndexerIoModeListener listener) {
        this.listeners.add(listener);
    }

    public void removeIndexerIoModeListener(IndexerIoModeListener listener) {
        this.listeners.remove(listener);
    }
}

