/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingClusterOperation;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContext;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;
import net.sf.ehcache.constructs.nonstop.concurrency.LockOperationTimedOutNonstopException;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopThreadUniqueIdProvider;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;

class NonstopSync
implements Sync {
    private final NonstopStore nonstopStore;
    private final ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal;
    private final Object key;
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final NonstopConfiguration nonstopConfiguration;

    public NonstopSync(NonstopStore nonstopStore, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal, Object key, NonstopConfiguration nonstopConfiguration) {
        this.nonstopStore = nonstopStore;
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.explicitLockingContextThreadLocal = explicitLockingContextThreadLocal;
        this.key = key;
        this.nonstopConfiguration = nonstopConfiguration;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isHeldByCurrentThread(final LockType type) {
        return this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperation<Boolean>(){

            @Override
            public Boolean performClusterOperation() {
                return NonstopSync.this.nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(NonstopSync.this.key).isHeldByCurrentThread(type);
            }

            @Override
            public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                throw new LockOperationTimedOutNonstopException("isHeldByCurrentThread() timed out");
            }
        });
    }

    @Override
    public void lock(LockType type) {
        boolean acquired = false;
        try {
            acquired = this.tryLock(type, this.nonstopConfiguration.getTimeoutMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!acquired) {
            throw new LockOperationTimedOutNonstopException("Lock timed out");
        }
    }

    @Override
    public boolean tryLock(LockType type, long msec) throws InterruptedException {
        ExplicitLockingContext appThreadLockContext = this.explicitLockingContextThreadLocal.getCurrentThreadLockContext();
        return this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperationImpl(type, msec, appThreadLockContext, LockOperationType.TRY_LOCK));
    }

    @Override
    public void unlock(LockType type) {
        ExplicitLockingContext appThreadLockContext = this.explicitLockingContextThreadLocal.getCurrentThreadLockContext();
        this.nonstopStore.executeClusterOperation(new ExplicitLockingClusterOperationImpl(type, -1L, appThreadLockContext, LockOperationType.UNLOCK));
    }

    private static enum OperationState {
        EXECUTING{

            @Override
            OperationState executionComplete() {
                return EXECUTION_COMPLETE;
            }

            @Override
            OperationState operationTimedOut() {
                return OPERATION_TIMED_OUT;
            }
        }
        ,
        EXECUTION_COMPLETE{

            @Override
            OperationState executionComplete() {
                throw new UnsupportedOperationException();
            }

            @Override
            OperationState operationTimedOut() {
                return EXECUTION_COMPLETE;
            }

            @Override
            boolean isExecutionComplete() {
                return true;
            }
        }
        ,
        OPERATION_TIMED_OUT{

            @Override
            OperationState executionComplete() {
                return OPERATION_TIMED_OUT;
            }

            @Override
            OperationState operationTimedOut() {
                throw new UnsupportedOperationException();
            }

            @Override
            boolean isOperationTimedOut() {
                return true;
            }
        };


        abstract OperationState executionComplete();

        abstract OperationState operationTimedOut();

        boolean isOperationTimedOut() {
            return false;
        }

        boolean isExecutionComplete() {
            return false;
        }
    }

    private static enum LockOperationType {
        TRY_LOCK{

            @Override
            public boolean performOperation(ExplicitLockingContext appThreadLockContext, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, Object key, long timeout, LockType type, NonstopConfiguration config) throws Exception {
                timeout = Math.min(config.getTimeoutMillis(), timeout);
                boolean success = nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(key).tryLock(type, timeout);
                if (success) {
                    appThreadLockContext.lockAcquired(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId());
                }
                return success;
            }

            @Override
            public void rollback(ExplicitLockingContext appThreadLockContext, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, Object key, LockType type, boolean success) {
                if (success) {
                    nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(key).unlock(type);
                    appThreadLockContext.lockReleased();
                }
            }
        }
        ,
        UNLOCK{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performOperation(ExplicitLockingContext appThreadLockContext, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, Object key, long timeout, LockType type, NonstopConfiguration config) throws Exception {
                try {
                    if (appThreadLockContext.areLocksAcquiredByOtherThreads(NonstopThreadUniqueIdProvider.getCurrentNonstopThreadUniqueId())) {
                        throw new InvalidLockStateAfterRejoinException();
                    }
                    nonstopActiveDelegateHolder.getUnderlyingCacheLockProvider().getSyncForKey(key).unlock(type);
                }
                finally {
                    appThreadLockContext.lockReleased();
                }
                return true;
            }

            @Override
            public void rollback(ExplicitLockingContext appThreadLockContext, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, Object key, LockType type, boolean success) {
            }
        };


        public abstract boolean performOperation(ExplicitLockingContext var1, NonstopActiveDelegateHolder var2, Object var3, long var4, LockType var6, NonstopConfiguration var7) throws Exception;

        public abstract void rollback(ExplicitLockingContext var1, NonstopActiveDelegateHolder var2, Object var3, LockType var4, boolean var5);
    }

    private class ExplicitLockingClusterOperationImpl
    implements ExplicitLockingClusterOperation<Boolean> {
        private final AtomicBoolean operationCompleted = new AtomicBoolean(false);
        private final LockType type;
        private final long timeout;
        private final LockOperationType lockOperationType;
        private final ExplicitLockingContext appThreadLockContext;
        private volatile OperationState state = OperationState.EXECUTING;

        public ExplicitLockingClusterOperationImpl(LockType type, long timeout, ExplicitLockingContext appThreadLockContext, LockOperationType lockOperationType) {
            this.type = type;
            this.timeout = timeout;
            this.appThreadLockContext = appThreadLockContext;
            this.lockOperationType = lockOperationType;
        }

        @Override
        public Boolean performClusterOperation() throws Exception {
            boolean success = this.lockOperationType.performOperation(this.appThreadLockContext, NonstopSync.this.nonstopActiveDelegateHolder, NonstopSync.this.key, this.timeout, this.type, NonstopSync.this.nonstopConfiguration);
            this.executionComplete();
            if (!this.isExecutionComplete()) {
                this.lockOperationType.rollback(this.appThreadLockContext, NonstopSync.this.nonstopActiveDelegateHolder, NonstopSync.this.key, this.type, success);
            }
            return this.isExecutionComplete() && success;
        }

        @Override
        public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
            this.operationTimedOut();
            if (this.isOperationTimedOut()) {
                throw new LockOperationTimedOutNonstopException("tryLock() timed out");
            }
            return true;
        }

        private synchronized void executionComplete() {
            this.state = this.state.executionComplete();
        }

        private synchronized void operationTimedOut() {
            this.state = this.state.operationTimedOut();
        }

        private synchronized boolean isOperationTimedOut() {
            return this.state.isOperationTimedOut();
        }

        private synchronized boolean isExecutionComplete() {
            return this.state.isExecutionComplete();
        }
    }
}

