/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.util.Collection;
import java.util.HashSet;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.Address;

public class ClusteredGetResponseValidityFilter
implements ResponseFilter {
    private Collection<Address> targets;
    private int acceptableResponses;
    private int missingResponses;

    public ClusteredGetResponseValidityFilter(Collection<Address> targets, Address self) {
        this.targets = new HashSet<Address>(targets);
        this.acceptableResponses = 0;
        this.missingResponses = targets.size();
        if (this.targets.contains(self)) {
            --this.missingResponses;
        }
    }

    @Override
    public boolean isAcceptable(Response response, Address address) {
        if (this.targets.contains(address)) {
            --this.missingResponses;
            if (response instanceof SuccessfulResponse || response instanceof ExceptionResponse) {
                ++this.acceptableResponses;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needMoreResponses() {
        return this.acceptableResponses < 1 && this.missingResponses > 0;
    }
}

