/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.esri.AsciiGridStore;
import org.apache.sis.internal.storage.esri.CharactersView;
import org.apache.sis.internal.storage.esri.WritableStore;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

@StoreMetadata(formatName="ASCII Grid", fileSuffixes={"asc", "grd", "agr", "aig"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={GridCoverageResource.class})
public final class AsciiGridStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "ASCII Grid";

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return this.probeContent(storageConnector, ByteBuffer.class, byteBuffer -> {
            block8: {
                byteBuffer.mark();
                while (byteBuffer.hasRemaining()) {
                    if (byteBuffer.get() >= 0) continue;
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                byteBuffer.reset();
                CharactersView charactersView = new CharactersView(null, (ByteBuffer)byteBuffer);
                try {
                    block9: {
                        Map<String, String> map = charactersView.readHeader();
                        if (!map.containsKey("NROWS") || !map.containsKey("NCOLS") || !map.containsKey("XLLCORNER") && !map.containsKey("XLLCENTER") || !map.containsKey("YLLCORNER") && !map.containsKey("YLLCENTER")) break block8;
                        if (!map.containsKey("CELLSIZE")) {
                            int n = 0;
                            int n2 = 0;
                            while (n2 < AsciiGridStore.CELLSIZES.length) {
                                if (map.containsKey(AsciiGridStore.CELLSIZES[n2++])) {
                                    n |= 1;
                                }
                                if (map.containsKey(AsciiGridStore.CELLSIZES[n2++])) {
                                    n |= 2;
                                }
                                if (n != 3) continue;
                                break block9;
                            }
                            return ProbeResult.UNSUPPORTED_STORAGE;
                        }
                    }
                    return new ProbeResult(true, "text/plain", null);
                }
                catch (EOFException eOFException) {
                    return ProbeResult.INSUFFICIENT_BYTES;
                }
                catch (DataStoreException dataStoreException) {
                    // empty catch block
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        });
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        if (AsciiGridStoreProvider.isWritable(storageConnector)) {
            return new WritableStore(this, storageConnector);
        }
        return new AsciiGridStore(this, storageConnector, true);
    }
}

