/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

public abstract class GridResourceWrapper
implements GridCoverageResource {
    private GridCoverageResource source;

    protected GridResourceWrapper() {
    }

    protected abstract Object getSynchronizationLock();

    protected abstract GridCoverageResource createSource() throws DataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GridCoverageResource source() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.source == null) {
                this.source = this.createSource();
            }
            return this.source;
        }
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return this.source().getIdentifier();
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        return this.source().getMetadata();
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return this.source().getEnvelope();
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreException {
        return this.source().getGridGeometry();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.source().getSampleDimensions();
    }

    @Override
    public List<double[]> getResolutions() throws DataStoreException {
        return this.source().getResolutions();
    }

    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        return this.source().read(gridGeometry, nArray);
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.source().getLoadingStrategy();
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) throws DataStoreException {
        return this.source().setLoadingStrategy(rasterLoadingStrategy);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        GridCoverageResource gridCoverageResource;
        try {
            gridCoverageResource = this.source();
        }
        catch (DataStoreException dataStoreException) {
            throw new BackingStoreException((Throwable)dataStoreException);
        }
        gridCoverageResource.addListener(clazz, storeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        GridCoverageResource gridCoverageResource;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            gridCoverageResource = this.source;
        }
        if (gridCoverageResource != null) {
            gridCoverageResource.removeListener(clazz, storeListener);
        }
    }

    public final void closeDataStore() throws DataStoreException {
        GridCoverageResource gridCoverageResource = this.source;
        this.source = null;
        if (gridCoverageResource instanceof StoreResource) {
            ((StoreResource)((Object)gridCoverageResource)).getOriginator().close();
        }
    }
}

