/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gmi.LE_ProcessStep;
import org.apache.sis.internal.jaxb.gml.TM_Primitive;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.ProcessStepReport;
import org.opengis.metadata.lineage.Processing;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.temporal.TemporalPrimitive;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="LI_ProcessStep_Type", propOrder={"description", "rationale", "stepDateTime", "date", "processors", "reference", "scope", "sources", "outputs", "processingInformation", "reports"})
@XmlRootElement(name="LI_ProcessStep")
@XmlSeeAlso(value={LE_ProcessStep.class})
public class DefaultProcessStep
extends ISOMetadata
implements ProcessStep {
    private static final long serialVersionUID = -2338712901907082970L;
    private InternationalString description;
    private InternationalString rationale;
    private TemporalPrimitive stepDateTime;
    private Collection<ResponsibleParty> processors;
    private Collection<Citation> references;
    private Scope scope;
    private Collection<Source> sources;
    private Collection<Source> outputs;
    private Processing processingInformation;
    private Collection<ProcessStepReport> reports;

    public DefaultProcessStep() {
    }

    public DefaultProcessStep(CharSequence charSequence) {
        this.description = Types.toInternationalString(charSequence);
    }

    public DefaultProcessStep(ProcessStep processStep) {
        super(processStep);
        if (processStep != null) {
            this.description = processStep.getDescription();
            this.rationale = processStep.getRationale();
            this.stepDateTime = TemporalUtilities.createInstant((Date)processStep.getDate());
            this.processors = this.copyCollection(processStep.getProcessors(), ResponsibleParty.class);
            this.sources = this.copyCollection(processStep.getSources(), Source.class);
            this.outputs = this.copyCollection(processStep.getOutputs(), Source.class);
            this.processingInformation = processStep.getProcessingInformation();
            this.reports = this.copyCollection(processStep.getReports(), ProcessStepReport.class);
            if (processStep instanceof DefaultProcessStep) {
                this.references = this.copyCollection(((DefaultProcessStep)processStep).getReferences(), Citation.class);
                this.scope = ((DefaultProcessStep)processStep).getScope();
            }
        }
    }

    public static DefaultProcessStep castOrCopy(ProcessStep processStep) {
        if (processStep == null || processStep instanceof DefaultProcessStep) {
            return (DefaultProcessStep)processStep;
        }
        return new DefaultProcessStep(processStep);
    }

    @XmlElement(name="description", required=true)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission(this.description);
        this.description = internationalString;
    }

    @XmlElement(name="rationale")
    public InternationalString getRationale() {
        return this.rationale;
    }

    public void setRationale(InternationalString internationalString) {
        this.checkWritePermission(this.rationale);
        this.rationale = internationalString;
    }

    @XmlElement(name="stepDateTime")
    @XmlJavaTypeAdapter(value=TM_Primitive.Since2014.class)
    public TemporalPrimitive getStepDateTime() {
        return this.stepDateTime;
    }

    public void setStepDateTime(TemporalPrimitive temporalPrimitive) {
        this.checkWritePermission(this.stepDateTime);
        this.stepDateTime = temporalPrimitive;
    }

    @Deprecated
    @XmlElement(name="dateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDate() {
        return FilterByVersion.LEGACY_METADATA.accept() ? TemporalUtilities.getDate((TemporalPrimitive)this.getStepDateTime()) : null;
    }

    @Deprecated
    public void setDate(Date date) {
        this.setStepDateTime((TemporalPrimitive)TemporalUtilities.createInstant((Date)date));
    }

    @XmlElement(name="processor")
    public Collection<ResponsibleParty> getProcessors() {
        this.processors = this.nonNullCollection(this.processors, ResponsibleParty.class);
        return this.processors;
    }

    public void setProcessors(Collection<? extends ResponsibleParty> collection) {
        this.processors = this.writeCollection(collection, this.processors, ResponsibleParty.class);
    }

    @UML(identifier="reference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getReferences() {
        this.references = this.nonNullCollection(this.references, Citation.class);
        return this.references;
    }

    public void setReferences(Collection<? extends Citation> collection) {
        this.references = this.writeCollection(collection, this.references, Citation.class);
    }

    @XmlElement(name="scope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="scope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.checkWritePermission(this.scope);
        this.scope = scope;
    }

    @XmlElement(name="source")
    public Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public void setSources(Collection<? extends Source> collection) {
        this.sources = this.writeCollection(collection, this.sources, Source.class);
    }

    @XmlElement(name="output")
    public Collection<Source> getOutputs() {
        this.outputs = this.nonNullCollection(this.outputs, Source.class);
        return this.outputs;
    }

    public void setOutputs(Collection<? extends Source> collection) {
        this.outputs = this.writeCollection(collection, this.outputs, Source.class);
    }

    @XmlElement(name="processingInformation")
    public Processing getProcessingInformation() {
        return this.processingInformation;
    }

    public void setProcessingInformation(Processing processing) {
        this.checkWritePermission(this.processingInformation);
        this.processingInformation = processing;
    }

    @XmlElement(name="report")
    public Collection<ProcessStepReport> getReports() {
        this.reports = this.nonNullCollection(this.reports, ProcessStepReport.class);
        return this.reports;
    }

    public void setReports(Collection<? extends ProcessStepReport> collection) {
        this.reports = this.writeCollection(collection, this.reports, ProcessStepReport.class);
    }

    @XmlElement(name="reference")
    private Collection<Citation> getReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getReferences() : null;
    }
}

