/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.StringHelper;

public class HighFrequencyDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;
    private float thresh;

    public HighFrequencyDictionary(IndexReader reader, String field, float thresh) {
        this.reader = reader;
        this.field = StringHelper.intern((String)field);
        this.thresh = thresh;
    }

    public final BytesRefIterator getWordsIterator() throws IOException {
        return new HighFrequencyIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class HighFrequencyIterator
    implements TermFreqIterator {
        private final BytesRef spare = new BytesRef();
        private final TermEnum termsEnum;
        private int minNumDocs;
        private long freq;
        private final Comparator<BytesRef> comp;

        HighFrequencyIterator() throws IOException {
            this.termsEnum = HighFrequencyDictionary.this.reader.terms(new Term(HighFrequencyDictionary.this.field, ""));
            this.minNumDocs = (int)(HighFrequencyDictionary.this.thresh * (float)HighFrequencyDictionary.this.reader.numDocs());
            Term term = this.termsEnum.term();
            this.comp = term == null || term.field() != HighFrequencyDictionary.this.field ? null : BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        private boolean isFrequent(int freq) {
            return freq >= this.minNumDocs;
        }

        @Override
        public long weight() {
            return this.freq;
        }

        public BytesRef next() throws IOException {
            if (this.termsEnum != null) {
                do {
                    Term actualTerm;
                    if ((actualTerm = this.termsEnum.term()) == null || actualTerm.field() != HighFrequencyDictionary.this.field) {
                        return null;
                    }
                    if (!this.isFrequent(this.termsEnum.docFreq())) continue;
                    this.freq = this.termsEnum.docFreq();
                    this.spare.copyChars((CharSequence)actualTerm.text());
                    this.termsEnum.next();
                    return this.spare;
                } while (this.termsEnum.next());
            }
            return null;
        }

        public Comparator<BytesRef> getComparator() {
            return this.comp;
        }
    }
}

