/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;

public class DefaultElementEvictionData
implements ElementEvictionData {
    private long creationTime;
    private long lastAccessTime;

    public DefaultElementEvictionData(long creationTime) {
        this.creationTime = creationTime;
    }

    public DefaultElementEvictionData(long creationTime, long lastAccessTime) {
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void updateLastAccessTime(long time, Element element) {
        this.lastAccessTime = time;
    }

    @Override
    public void resetLastAccessTime(Element element) {
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public final ElementEvictionData clone() throws CloneNotSupportedException {
        DefaultElementEvictionData result = (DefaultElementEvictionData)super.clone();
        result.creationTime = this.creationTime;
        result.lastAccessTime = this.lastAccessTime;
        return result;
    }

    @Override
    public boolean canParticipateInSerialization() {
        return true;
    }
}

