/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.ArrayList;
import java.util.Collection;

public final class CollectionType {
    private static ArrayList<CollectionType> members = new ArrayList(20);
    public static final CollectionType NONE = new CollectionType("");
    public static final CollectionType TIMESERIES = new CollectionType("TimeSeries");
    public static final CollectionType STATIONS = new CollectionType("Stations");
    public static final CollectionType FORECASTS = new CollectionType("ForecastModelRuns");
    private String name;

    private CollectionType(String s) {
        this.name = s;
        members.add(this);
    }

    private CollectionType(String name, boolean fake) {
        this.name = name;
    }

    public static Collection<CollectionType> getAllTypes() {
        return members;
    }

    public static CollectionType findType(String name) {
        if (name == null) {
            return null;
        }
        for (CollectionType m : members) {
            if (!m.name.equalsIgnoreCase(name)) continue;
            return m;
        }
        return null;
    }

    public static CollectionType getType(String name) {
        if (name == null) {
            return null;
        }
        CollectionType type = CollectionType.findType(name);
        return type != null ? type : new CollectionType(name, false);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionType)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }
}

