/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.generic;

import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.generic.LookupCommand;

public class DispatchLookupCommand<C extends Context>
extends LookupCommand<C> {
    private static final Class<?>[] DEFAULT_SIGNATURE = new Class[]{Context.class};
    private WeakHashMap<String, Method> methods = new WeakHashMap();
    private String method = null;
    private String methodKey = null;

    public DispatchLookupCommand() {
    }

    public DispatchLookupCommand(CatalogFactory<C> factory) {
        super(factory);
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMethodKey(String methodKey) {
        this.methodKey = methodKey;
    }

    @Override
    public boolean execute(C context) throws Exception {
        if (this.getMethod() == null && this.getMethodKey() == null) {
            throw new IllegalStateException("Neither 'method' nor 'methodKey' properties are defined ");
        }
        Command<C> command = this.getCommand(context);
        if (command != null) {
            Method methodObject = this.extractMethod(command, context);
            Object obj = methodObject.invoke(command, this.getArguments(context));
            return obj instanceof Boolean && (Boolean)obj != false;
        }
        return false;
    }

    protected Class<?>[] getSignature() {
        return DEFAULT_SIGNATURE;
    }

    protected Object[] getArguments(C context) {
        return new Object[]{context};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method extractMethod(Command<C> command, C context) throws NoSuchMethodException {
        String methodName = this.getMethod();
        if (methodName == null) {
            Object methodContextObj = context.get(this.getMethodKey());
            if (methodContextObj == null) {
                throw new NullPointerException("No value found in context under " + this.getMethodKey());
            }
            methodName = methodContextObj.toString();
        }
        Method theMethod = null;
        WeakHashMap<String, Method> weakHashMap = this.methods;
        synchronized (weakHashMap) {
            theMethod = this.methods.get(methodName);
            if (theMethod == null) {
                theMethod = command.getClass().getMethod(methodName, this.getSignature());
                this.methods.put(methodName, theMethod);
            }
        }
        return theMethod;
    }
}

