/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.ProcessingQueue;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Util;

@MBean(description="State transfer protocol based on byte array transfer")
public class STATE_TRANSFER
extends Protocol
implements ProcessingQueue.Handler<Address> {
    protected long start;
    protected long stop;
    protected final AtomicInteger num_state_reqs = new AtomicInteger(0);
    protected final AtomicLong num_bytes_sent = new AtomicLong(0L);
    protected double avg_state_size = 0.0;
    protected Address local_addr;
    protected volatile View view;
    protected final List<Address> members = new ArrayList<Address>();
    protected final ProcessingQueue<Address> state_requesters = new ProcessingQueue<Address>().setHandler(this);
    protected volatile boolean waiting_for_state_response = false;
    protected boolean flushProtocolInStack = false;

    @ManagedAttribute
    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    @ManagedAttribute
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    @ManagedAttribute
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public List<Integer> requiredDownServices() {
        return Arrays.asList(39, 42);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", Boolean.TRUE);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
    }

    @Override
    public void stop() {
        super.stop();
        this.waiting_for_state_response = false;
    }

    @ManagedOperation(description="Closes BARRIER and suspends STABLE")
    public void closeBarrierAndSuspendStable() {
        if (!this.isDigestNeeded()) {
            return;
        }
        this.log.trace("%s: sending down CLOSE_BARRIER and SUSPEND_STABLE", this.local_addr);
        this.down_prot.down(new Event(76));
        this.down_prot.down(new Event(65));
    }

    @ManagedOperation(description="Opens BARRIER and resumes STABLE")
    public void openBarrierAndResumeStable() {
        if (!this.isDigestNeeded()) {
            return;
        }
        this.log.trace("%s: sending down OPEN_BARRIER and RESUME_STABLE", this.local_addr);
        this.down_prot.down(new Event(77));
        this.down_prot.down(new Event(66));
    }

    public void openBarrier() {
        if (!this.isDigestNeeded()) {
            return;
        }
        this.log.trace("%s: sending down OPEN_BARRIER", this.local_addr);
        this.down_prot.down(new Event(77));
    }

    public void resumeStable() {
        this.log.trace("%s: sending down RESUME_STABLE", this.local_addr);
        this.down_prot.down(new Event(66));
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.state_requesters.add(msg.getSrc());
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr.getDigest(), msg.getSrc(), msg.getBuffer());
                        break;
                    }
                    case 3: {
                        this.closeHoleFor(msg.getSrc());
                        this.handleException((Throwable)msg.getObject());
                        break;
                    }
                    default: {
                        this.log.error("%s: type %s not known in StateHeader", this.local_addr, hdr.type);
                    }
                }
                return null;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("state_transfer")) break;
                this.log.error(Util.getMessage("ProtocolStackCannotContainTwoStateTransferProtocolsRemoveEitherOneOfThem"));
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        this.log.error("%s: cannot fetch state from myself", this.local_addr);
                        target = null;
                    }
                }
                if (target == null) {
                    this.log.debug("%s: first member (no state)", this.local_addr);
                    this.up_prot.up(new Event(20, new StateTransferInfo()));
                } else {
                    Message state_req = new Message(target).putHeader(this.id, new StateHeader(1)).setFlag(Message.Flag.DONT_BUNDLE, Message.Flag.OOB, Message.Flag.SKIP_BARRIER);
                    this.log.debug("%s: asking %s for state", this.local_addr, target);
                    this.waiting_for_state_response = true;
                    this.start = System.currentTimeMillis();
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    protected boolean isDigestNeeded() {
        return !this.flushProtocolInStack;
    }

    protected void punchHoleFor(Address member) {
        this.down_prot.down(new Event(106, member));
    }

    protected void closeHoleFor(Address member) {
        this.down_prot.down(new Event(107, member));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        List<Address> list = this.members;
        synchronized (list) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        Address old_coord;
        List<Address> new_members = v.getMembers();
        boolean send_up_exception = false;
        this.view = v;
        List<Address> list = this.members;
        synchronized (list) {
            old_coord = !this.members.isEmpty() ? this.members.get(0) : null;
            this.members.clear();
            this.members.addAll(new_members);
            if (this.waiting_for_state_response && old_coord != null && !this.members.contains(old_coord)) {
                send_up_exception = true;
            }
        }
        if (send_up_exception) {
            this.log.warn("%s: discovered that the state provider (%s) left", this.local_addr, old_coord);
            this.waiting_for_state_response = false;
            EOFException ex = new EOFException("state provider " + old_coord + " left");
            this.up_prot.up(new Event(20, new StateTransferResult(ex)));
            this.openBarrierAndResumeStable();
        }
        this.state_requesters.retainAll(new_members);
    }

    protected void handleException(Throwable exception) {
        if (this.isDigestNeeded()) {
            this.openBarrierAndResumeStable();
        }
        this.up_prot.up(new Event(20, new StateTransferResult(exception)));
    }

    @Override
    public void handle(Address state_requester) {
        this.handleStateReq(state_requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStateReq(Address requester) {
        if (requester == null) {
            return;
        }
        this.log.debug("%s: received state request from %s", this.local_addr, requester);
        Digest digest = null;
        if (this.isDigestNeeded()) {
            try {
                this.punchHoleFor(requester);
                this.closeBarrierAndSuspendStable();
                digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
            }
            catch (Throwable t) {
                this.sendException(requester, t);
                this.resumeStable();
                this.closeHoleFor(requester);
                return;
            }
            finally {
                this.openBarrier();
            }
        }
        try {
            this.getStateFromApplication(requester, digest);
        }
        catch (Throwable t) {
            this.sendException(requester, t);
        }
        finally {
            if (this.isDigestNeeded()) {
                this.closeHoleFor(requester);
                this.resumeStable();
            }
        }
    }

    protected void getStateFromApplication(Address requester, Digest digest) {
        StateTransferInfo rsp = (StateTransferInfo)this.up_prot.up(new Event(17));
        byte[] state = rsp.state;
        if (this.stats) {
            this.num_state_reqs.incrementAndGet();
            if (state != null) {
                this.num_bytes_sent.addAndGet(state.length);
            }
            this.avg_state_size = this.num_bytes_sent.doubleValue() / this.num_state_reqs.doubleValue();
        }
        Message state_rsp = new Message(requester, state).putHeader(this.id, new StateHeader(2, digest));
        this.log.trace("%s: sending state to %s (size=%s)", this.local_addr, state_rsp.getDest(), Util.printBytes(state != null ? (long)state.length : 0L));
        this.down_prot.down(new Event(1, state_rsp));
    }

    protected void sendException(Address requester, Throwable exception) {
        try {
            Message ex_msg = new Message(requester, exception).putHeader(this.getId(), new StateHeader(3));
            this.down(new Event(1, ex_msg));
        }
        catch (Throwable t) {
            this.log.error("%s: failed sending exception %s to %s", this.local_addr, exception, requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStateRsp(Digest digest, Address sender, byte[] state) {
        try {
            if (this.isDigestNeeded()) {
                this.punchHoleFor(sender);
                this.closeBarrierAndSuspendStable();
                if (digest != null) {
                    this.down_prot.down(new Event(42, digest));
                }
            }
            this.waiting_for_state_response = false;
            this.stop = System.currentTimeMillis();
            this.log.debug("%s: received state, size=%s, time=%d milliseconds", this.local_addr, state == null ? "0" : Util.printBytes(state.length), this.stop - this.start);
            StateTransferResult result = new StateTransferResult(state);
            this.up_prot.up(new Event(20, result));
            this.down_prot.down(new Event(108));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            if (this.isDigestNeeded()) {
                this.closeHoleFor(sender);
                this.openBarrierAndResumeStable();
            }
        }
    }

    public static class StateHeader
    extends Header {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_EX = 3;
        protected byte type = 0;
        protected Digest my_digest;

        public StateHeader() {
        }

        public StateHeader(byte type) {
            this.type = type;
        }

        public StateHeader(byte type, Digest digest) {
            this.type = type;
            this.my_digest = digest;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_EX";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeStreamable(this.my_digest, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
        }

        @Override
        public int size() {
            int retval = 1;
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize(true));
            }
            return retval;
        }
    }
}

