/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;

public class LocalNameQuery
extends Query {
    private static final long serialVersionUID = 235655337620030844L;
    private final String localName;
    private final IndexFormatVersion version;

    public LocalNameQuery(String localName, IndexFormatVersion version) {
        this.localName = localName;
        this.version = version;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.version.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            return new JcrTermQuery(new Term(FieldNames.LOCAL_NAME, this.localName));
        }
        throw new IOException("LocalNameQuery requires IndexFormatVersion V3");
    }

    public void extractTerms(Set<Term> terms) {
    }

    public String toString(String field) {
        return "local-name() = " + this.localName;
    }
}

