/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public abstract class GridCoverage
extends BandedCoverage {
    final GridGeometry gridGeometry;
    private final SampleDimension[] sampleDimensions;
    private transient GridCoverage packedView;
    private transient GridCoverage convertedView;

    protected GridCoverage(GridGeometry gridGeometry, List<? extends SampleDimension> list) {
        ArgumentChecks.ensureNonNull((String)"domain", (Object)gridGeometry);
        ArgumentChecks.ensureNonEmpty((String)"ranges", list);
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = list.toArray(new SampleDimension[list.size()]);
        ArgumentChecks.ensureNonEmpty((String)"range", (Object[])this.sampleDimensions);
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"range", (int)i, (Object)this.sampleDimensions[i]);
        }
    }

    GridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry) {
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = gridCoverage.sampleDimensions;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridGeometry.getCoordinateReferenceSystem();
    }

    @Override
    public Optional<Envelope> getEnvelope() {
        if (this.gridGeometry.isDefined(2)) {
            return Optional.of(this.gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return UnmodifiableArrayList.wrap((Object[])this.sampleDimensions);
    }

    private NumberRange<?>[] getRanges() {
        NumberRange[] numberRangeArray = null;
        for (int i = 0; i < this.sampleDimensions.length; ++i) {
            Optional<NumberRange<?>> optional = this.sampleDimensions[i].getSampleRange();
            if (!optional.isPresent()) continue;
            if (numberRangeArray == null) {
                numberRangeArray = new NumberRange[this.sampleDimensions.length];
            }
            numberRangeArray[i] = optional.get();
        }
        return numberRangeArray;
    }

    DataType getBandType() {
        return DataType.DOUBLE;
    }

    final GridCoverage getView(boolean bl) {
        return bl ? this.convertedView : this.packedView;
    }

    final void setView(boolean bl, GridCoverage gridCoverage) {
        if (bl) {
            this.convertedView = gridCoverage;
        } else {
            this.packedView = gridCoverage;
        }
    }

    public synchronized GridCoverage forConvertedValues(boolean bl) {
        GridCoverage gridCoverage = this.getView(bl);
        if (gridCoverage == null) {
            try {
                gridCoverage = ConvertedGridCoverage.create(this, bl);
                this.setView(bl, gridCoverage);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new CannotEvaluateException(noninvertibleTransformException.getMessage(), noninvertibleTransformException);
            }
        }
        return gridCoverage;
    }

    final RenderedImage convert(RenderedImage renderedImage, DataType dataType, MathTransform1D[] mathTransform1DArray) {
        int n = Math.max(0, ImageUtilities.getVisibleBand(renderedImage));
        Colorizer colorizer = new Colorizer(Colorizer.GRAYSCALE);
        ColorModel colorModel = colorizer.initialize(renderedImage.getSampleModel(), this.sampleDimensions[n]) || colorizer.initialize(renderedImage.getColorModel()) ? colorizer.createColorModel(dataType.toDataBufferType(), this.sampleDimensions.length, n) : Colorizer.NULL_COLOR_MODEL;
        return Lazy.PROCESSOR.convert(renderedImage, this.getRanges(), mathTransform1DArray, dataType, colorModel);
    }

    @Override
    public GridEvaluator evaluator() {
        return new GridEvaluator(this);
    }

    public abstract RenderedImage render(GridExtent var1);

    public String toString() {
        return this.toTree(Locale.getDefault(), this.gridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int n) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        TableColumn tableColumn = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(new TableColumn[]{tableColumn});
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(tableColumn, (Object)Classes.getShortClassName((Object)this));
        TreeTable.Node node2 = node.newChild();
        node2.setValue(tableColumn, (Object)vocabulary.getString((short)39));
        this.gridGeometry.formatTo(locale, vocabulary, n, node2);
        this.appendDataLayout(node, vocabulary, (TableColumn<CharSequence>)tableColumn);
        node2 = node.newChild();
        node2.setValue(tableColumn, (Object)vocabulary.getString((short)178));
        node2.newChild().setValue(tableColumn, (Object)SampleDimension.toString(locale, this.sampleDimensions));
        return defaultTreeTable;
    }

    void appendDataLayout(TreeTable.Node node, Vocabulary vocabulary, TableColumn<CharSequence> tableColumn) {
    }

    private static final class Lazy {
        private static final ImageProcessor PROCESSOR = new ImageProcessor();

        private Lazy() {
        }
    }
}

