/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.CommittableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;

class VolatileIndex
extends AbstractIndex {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private final Map<String, Document> pending = new LinkedMap();
    private final Map<String, Document> aggregateIndexes = new LinkedMap();
    private int bufferSize = 10;
    private int numDocs = 0;

    VolatileIndex(Analyzer analyzer, Similarity similarity) throws IOException {
        super(analyzer, similarity, (Directory)new RAMDirectory(), null, null);
    }

    @Override
    void addDocuments(Document[] docs) throws IOException {
        for (int i = 0; i < docs.length; ++i) {
            Document old = this.pending.put(docs[i].get(FieldNames.UUID), docs[i]);
            if (old != null) {
                Util.disposeDocument(old);
            }
            if (this.pending.size() >= this.bufferSize) {
                this.commitPending();
            }
            ++this.numDocs;
        }
        this.invalidateSharedReader();
    }

    Document getAggregateIndexes(String uuid) {
        return this.aggregateIndexes.get(uuid);
    }

    void addAggregateIndexes(Document doc) {
        Document old = this.aggregateIndexes.put(doc.get(FieldNames.UUID), doc);
        if (old != null) {
            Util.disposeDocument(old);
        }
    }

    @Override
    int removeDocument(Term idTerm) throws IOException {
        int num;
        Document doc = this.pending.remove(idTerm.text());
        if (doc != null) {
            Util.disposeDocument(doc);
            num = 1;
        } else {
            num = super.getIndexReader().deleteDocuments(idTerm);
        }
        this.numDocs -= num;
        return num;
    }

    int getNumDocuments() {
        return this.numDocs;
    }

    @Override
    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        this.commitPending();
        return super.getIndexReader();
    }

    @Override
    protected synchronized void commit(boolean optimize) throws IOException {
        this.commitPending();
        super.commit(optimize);
    }

    @Override
    long getRamSizeInBytes() {
        return super.getRamSizeInBytes() + ((RAMDirectory)this.getDirectory()).sizeInBytes();
    }

    void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private void commitPending() throws IOException {
        if (this.pending.isEmpty()) {
            return;
        }
        super.addDocuments(this.pending.values().toArray(new Document[this.pending.size()]));
        this.pending.clear();
        this.aggregateIndexes.clear();
    }
}

