/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.BaseNumericValue;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import java.math.BigDecimal;

public class DoubleValue
extends BaseNumericValue {
    private final Double _val;

    public DoubleValue(Double val) {
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.DOUBLE;
    }

    @Override
    public Object get() {
        return this._val;
    }

    @Override
    protected Number getNumber() {
        return this._val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return this._val != 0.0;
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this._val;
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this._val);
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return NumberFormatter.format(this._val);
    }
}

