/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.operations;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;

public class ValueURLIOHelper {
    private ValueURLIOHelper() {
    }

    public static InputStream getContent(ValueStoragePlugin plugin, ValueData value, String resourceId, boolean spoolContent) throws IOException {
        StreamPersistedValueData streamed;
        if (value.isByteArray()) {
            return new ByteArrayInputStream(value.getAsByteArray());
        }
        if (value instanceof StreamPersistedValueData && !(streamed = (StreamPersistedValueData)value).isPersisted()) {
            SpoolFile tempFile = streamed.getTempFile();
            InputStream stream = tempFile != null ? new FileInputStream(tempFile) : streamed.getStream();
            InputStream result = streamed.setPersistedURL(plugin.createURL(resourceId), spoolContent);
            return result != null ? result : stream;
        }
        return value.getAsStream();
    }
}

