/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sis.internal.geoapi.filter.SortOrder;
import org.apache.sis.internal.geoapi.filter.SortProperty;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

final class DefaultSortProperty<R>
implements SortProperty<R>,
Serializable {
    private static final long serialVersionUID = 6065805794498223206L;
    private final ValueReference<? super R, ?> property;
    private final boolean descending;

    DefaultSortProperty(ValueReference<? super R, ?> valueReference, SortOrder sortOrder) {
        ArgumentChecks.ensureNonNull((String)"property", valueReference);
        ArgumentChecks.ensureNonNull((String)"order", (Object)((Object)sortOrder));
        this.property = valueReference;
        this.descending = SortOrder.DESCENDING.equals((Object)sortOrder);
    }

    @Override
    public ValueReference<? super R, ?> getValueReference() {
        return this.property;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.descending ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }

    @Override
    public int compare(R r, R r2) {
        Object object;
        if (this.descending) {
            object = r;
            r = r2;
            r2 = object;
        }
        if (r == null) {
            return 1;
        }
        if (r2 == null) {
            return -1;
        }
        object = this.property.apply(r);
        Object v = this.property.apply(r2);
        if (object == null) {
            return 1;
        }
        if (v == null) {
            return -1;
        }
        if (object instanceof Comparable && v instanceof Comparable) {
            return ((Comparable)object).compareTo(v);
        }
        if (object instanceof Iterable) {
            return Containers.compare(((Iterable)object).iterator(), (Iterator)DefaultSortProperty.iterator(v));
        }
        if (v instanceof Iterable) {
            return Containers.compare((Iterator)DefaultSortProperty.iterator(object), ((Iterable)v).iterator());
        }
        throw new ClassCastException(Errors.format((short)59, (Object)this.property.getXPath(), Comparable.class, (object instanceof Comparable ? v : object).getClass()));
    }

    private static Iterator iterator(Object object) {
        return object instanceof Iterable ? ((Iterable)object).iterator() : Collections.singleton(object).iterator();
    }

    public int hashCode() {
        return this.property.hashCode() + Boolean.hashCode(this.descending);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultSortProperty) {
            DefaultSortProperty defaultSortProperty = (DefaultSortProperty)object;
            return this.descending == defaultSortProperty.descending && this.property.equals(defaultSortProperty.property);
        }
        return false;
    }
}

