/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class NdbcNetcdf4
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        if (ds.getFileTypeId().equals("HDF5")) {
            return false;
        }
        String dataProvider = ds.findAttValueIgnoreCase(null, "data_provider", null);
        if (dataProvider == null) {
            dataProvider = ds.findAttValueIgnoreCase(null, "institution", "");
        }
        if (!dataProvider.contains("National Data Buoy Center")) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "station_name", null)) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "nominal_latitude", null)) {
            return false;
        }
        return null != ds.findAttValueIgnoreCase(null, "nominal_longitude", null);
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        CoordinateAxis axis;
        Dimension obsDim = ds.findDimension("time");
        if (obsDim == null && (axis = CoordSysEvaluator.findCoordByType(ds, AxisType.Time)) != null && axis.isScalar()) {
            obsDim = axis.getDimension(0);
        }
        if (obsDim == null) {
            errlog.format("Must have an Observation dimension: unlimited dimension, or from Time Coordinate", new Object[0]);
            return null;
        }
        boolean hasStruct = Evaluator.hasNetcdf3RecordStructure(ds);
        TableConfig nt = new TableConfig(Table.Type.Top, "station");
        nt.featureType = FeatureType.STATION;
        nt.lat = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lat);
        nt.lon = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lon);
        nt.stnId = ds.findAttValueIgnoreCase(null, "station_name", null);
        nt.stnWmoId = ds.findAttValueIgnoreCase(null, "wmo_id", null);
        nt.stnDesc = ds.findAttValueIgnoreCase(null, "description", null);
        if (nt.stnDesc == null) {
            nt.stnDesc = ds.findAttValueIgnoreCase(null, "comment", null);
        }
        TableConfig obs = new TableConfig(Table.Type.Structure, hasStruct ? "record" : obsDim.getShortName());
        obs.structName = "record";
        obs.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        obs.dimName = obsDim.getShortName();
        obs.time = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Time);
        nt.addChild(obs);
        return nt;
    }
}

