/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.net.URL;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.StandaloneContainer;

public class CacheServer {
    private static final String DEFAULT_CONFIG_FILE_PATH = "/conf/cache-server-configuration.xml";

    private static void help(String errorMessage) {
        StringBuilder sb = new StringBuilder();
        if (errorMessage != null) {
            sb.append(errorMessage + ", t");
        } else {
            sb.append("T");
        }
        sb.append("he expected arguments are: help|?|<configuration-file-path>|udp|tcp <initial-hosts>");
        System.err.println(sb.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        String configPath;
        block9: {
            String arg;
            block11: {
                block10: {
                    if (args != null && args.length != 0) break block10;
                    configPath = DEFAULT_CONFIG_FILE_PATH;
                    break block9;
                }
                if (args.length != 1) break block11;
                arg = args[0];
                if ("help".equals(arg) || "?".equals(arg)) {
                    CacheServer.help(null);
                    return;
                }
                if ("udp".equals(arg)) {
                    configPath = DEFAULT_CONFIG_FILE_PATH;
                    break block9;
                } else if ("tcp".equals(arg)) {
                    configPath = DEFAULT_CONFIG_FILE_PATH;
                    CacheServer.addTCP2ProfileList();
                    PropertyManager.setProperty((String)"jgroups.bind_addr", (String)"127.0.0.1");
                    System.out.println("No initial hosts have been configured so the bind address has been automatically set to 127.0.0.1 assuming that it has been properly configured to map to localhost");
                    break block9;
                } else {
                    configPath = arg;
                }
                break block9;
            }
            if (args.length != 2) {
                CacheServer.help("Too many arguments");
                return;
            }
            arg = args[0];
            if (!"tcp".equals(arg)) {
                CacheServer.help("Unexpected syntax");
                return;
            }
            configPath = DEFAULT_CONFIG_FILE_PATH;
            CacheServer.addTCP2ProfileList();
            PropertyManager.setProperty((String)"jgroups.tcpping.initial_hosts", (String)args[1]);
            System.out.println("The initial hosts have been configured to:" + args[1]);
        }
        System.out.println("The configuration file will be loaded from '" + configPath + "'");
        URL configUrl = CacheServer.class.getResource(configPath);
        if (configUrl != null) {
            StandaloneContainer.addConfigurationURL((String)configUrl.toString());
        } else {
            StandaloneContainer.addConfigurationPath((String)configPath);
        }
        StandaloneContainer.getInstance();
    }

    private static void addTCP2ProfileList() {
        String profiles = PropertyManager.getProperty((String)"exo.profiles");
        StringBuilder sb = new StringBuilder();
        if (profiles != null && !profiles.isEmpty()) {
            sb.append(profiles);
            sb.append(',');
        }
        sb.append("tcp");
        PropertyManager.setProperty((String)"exo.profiles", (String)sb.toString());
        System.out.println("The tcp stack has been enabled");
    }
}

