/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.util.Collection;
import java.util.List;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArraysExt;

final class DimensionWrapper
extends Dimension {
    private final ucar.nc2.Dimension netcdf;
    private final int index;

    static List<Dimension> wrap(Collection<ucar.nc2.Dimension> collection) {
        Object[] objectArray = new DimensionWrapper[collection.size()];
        int n = 0;
        for (ucar.nc2.Dimension dimension : collection) {
            objectArray[n] = new DimensionWrapper(dimension, n);
            ++n;
        }
        return UnmodifiableArrayList.wrap((Object[])((Dimension[])ArraysExt.resize((Object[])objectArray, (int)n)));
    }

    static ucar.nc2.Dimension[] unwrap(Dimension[] dimensionArray) {
        ucar.nc2.Dimension[] dimensionArray2 = new ucar.nc2.Dimension[dimensionArray.length];
        for (int i = 0; i < dimensionArray2.length; ++i) {
            dimensionArray2[i] = ((DimensionWrapper)dimensionArray[i]).netcdf;
        }
        return dimensionArray2;
    }

    DimensionWrapper(ucar.nc2.Dimension dimension, int n) {
        this.netcdf = dimension;
        this.index = n;
    }

    @Override
    public String getName() {
        return this.netcdf.getShortName();
    }

    @Override
    public long length() {
        return this.netcdf.getLength();
    }

    @Override
    protected boolean isUnlimited() {
        return this.netcdf.isUnlimited();
    }

    @Override
    protected Dimension decrementIndex() {
        return new DimensionWrapper(this.netcdf, this.index - 1);
    }

    public boolean equals(Object object) {
        if (object instanceof DimensionWrapper) {
            DimensionWrapper dimensionWrapper = (DimensionWrapper)object;
            if (this.netcdf.equals((Object)dimensionWrapper.netcdf)) {
                return this.netcdf.isShared() || dimensionWrapper.index == this.index;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = ~this.netcdf.hashCode();
        if (!this.netcdf.isShared()) {
            n += 37 * this.index;
        }
        return n;
    }
}

