/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.artifact.CRCGenerator;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

@Path(value="/maven2-structure-corrector/")
public class ArtifactStructureCorrector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ArtifactStructureCorrector.class);
    private RepositoryService repoService;
    private String repoWorkspaceName;
    private String rootNodePath;
    private SessionProvider sessionProvider;

    public ArtifactStructureCorrector(InitParams initParams, RepositoryService repoService, Authenticator authenticator) throws Exception {
        this.repoService = repoService;
        if (initParams == null) {
            throw new RepositoryConfigurationException("Init parameters expected !!!");
        }
        PropertiesParam props = initParams.getPropertiesParam("artifact.workspace");
        if (props == null) {
            throw new RepositoryConfigurationException("Property parameters 'locations' expected");
        }
        this.repoWorkspaceName = props.getProperty("workspace");
        this.rootNodePath = props.getProperty("rootNode");
        String username = props.getProperty("username");
        String password = props.getProperty("password");
        String userId = authenticator.validateUser(new Credential[]{new UsernameCredential(username), new PasswordCredential(password)});
        this.sessionProvider = new SessionProvider(new ConversationState(authenticator.createIdentity(userId)));
    }

    @GET
    public Response correctStructure() throws RepositoryException {
        new Thread((Runnable)new ChecksumGenerator(this.currentSession(this.sessionProvider)), "Correct jcr struct, Append checksums to artifacts").start();
        return Response.ok().build();
    }

    private Session currentSession(SessionProvider sp) throws RepositoryException {
        return sp.getSession(this.repoWorkspaceName, this.repoService.getCurrentRepository());
    }

    class ChecksumGenerator
    implements Runnable {
        private Session session;

        public ChecksumGenerator(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            LOG.info((Object)"Maven artifact checksums Updater started");
            try {
                Node rootNode = (Node)this.session.getItem(ArtifactStructureCorrector.this.rootNodePath);
                this.jcrSpaning(rootNode);
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)"Cannot get target node", (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error((Object)"General repository exception", (Throwable)e);
            }
            LOG.info((Object)"Maven artifact checksums Updater finished!");
        }

        private void jcrSpaning(Node current_root) throws RepositoryException {
            String algorithm = "sha1";
            NodeIterator nodeIterator = current_root.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("nt:file")) {
                    this.jcrSpaning(node);
                    continue;
                }
                String path = node.getPath();
                String ext = FilenameUtils.getExtension((String)path);
                if (!ext.equalsIgnoreCase(algorithm)) {
                    try {
                        this.session.getItem(path + "." + algorithm);
                    }
                    catch (PathNotFoundException e) {
                        Node resource_node = (Node)this.session.getItem(path);
                        this.addChecksumNode(resource_node);
                    }
                    catch (ItemExistsException e) {
                        LOG.info((Object)("There is checksum for : " + node.getName()));
                    }
                }
                this.session.refresh(true);
                this.session.save();
            }
        }

        private void addChecksumNode(Node src) throws RepositoryException {
            Node parent = src.getParent();
            Node content = src.getNode("jcr:content");
            Property data = content.getProperty("jcr:data");
            String algorithm = "SHA1";
            try {
                String checksum = CRCGenerator.getChecksum(data.getStream(), algorithm);
                LOG.info((Object)("Generate checksum for : " + src.getName()));
                Node checkNode = parent.addNode(src.getName() + "." + algorithm.toLowerCase(), "nt:file");
                ByteArrayInputStream checksum_is = new ByteArrayInputStream(checksum.getBytes());
                String mimeType = "text/plain";
                Node sum_content = checkNode.addNode("jcr:content", "nt:resource");
                sum_content.setProperty("jcr:mimeType", mimeType);
                sum_content.setProperty("jcr:lastModified", Calendar.getInstance());
                sum_content.setProperty("jcr:data", (InputStream)checksum_is);
                IOUtils.closeQuietly((InputStream)checksum_is);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"Cannot eval checksum with this algorithm", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Streams exception while eval checksums", (Throwable)e);
            }
        }
    }
}

