/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.MultiValueColumnInfo;
import com.healthmarketscience.jackcess.complex.SingleValue;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.IOException;

public class MultiValueColumnInfoImpl
extends ComplexColumnInfoImpl<SingleValue>
implements MultiValueColumnInfo {
    private final Column _valueCol = this.getTypeColumns().get(0);

    public MultiValueColumnInfoImpl(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.MULTI_VALUE;
    }

    public Column getValueColumn() {
        return this._valueCol;
    }

    @Override
    protected SingleValueImpl toValue(ComplexValueForeignKey complexValueFk, Row rawValue) {
        ComplexColumnInfoImpl.ComplexValueIdImpl id = this.getValueId(rawValue);
        Object value = this.getValueColumn().getRowValue(rawValue);
        return new SingleValueImpl(id, complexValueFk, value);
    }

    @Override
    protected Object[] asRow(Object[] row, SingleValue value) throws IOException {
        super.asRow(row, value);
        this.getValueColumn().setRowValue(row, value.get());
        return row;
    }

    public static SingleValue newSingleValue(Object value) {
        return MultiValueColumnInfoImpl.newSingleValue(INVALID_FK, value);
    }

    public static SingleValue newSingleValue(ComplexValueForeignKey complexValueFk, Object value) {
        return new SingleValueImpl(INVALID_ID, complexValueFk, value);
    }

    private static class SingleValueImpl
    extends ComplexColumnInfoImpl.ComplexValueImpl
    implements SingleValue {
        private Object _value;

        private SingleValueImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk, Object value) {
            super(id, complexValueFk);
            this._value = value;
        }

        @Override
        public Object get() {
            return this._value;
        }

        @Override
        public void set(Object value) {
            this._value = value;
        }

        @Override
        public void update() throws IOException {
            this.getComplexValueForeignKey().updateMultiValue(this);
        }

        @Override
        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteMultiValue(this);
        }

        public String toString() {
            return "SingleValue(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.get();
        }
    }
}

