/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.FilterName;
import org.apache.sis.filter.FilterNode;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.util.ArgumentChecks;

final class IdentifierFilter<R extends AbstractFeature>
extends FilterNode<R> {
    private static final long serialVersionUID = 1404452049863376235L;
    private final String identifier;

    IdentifierFilter(String string) {
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)string);
        this.identifier = string;
    }

    @Override
    public Enum<?> getOperatorType() {
        return FilterName.RESOURCE_ID;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<Expression<? super R, ?>> getExpressions() {
        return Collections.singletonList(new LeafExpression.Literal(this.identifier));
    }

    @Override
    protected Collection<?> getChildren() {
        return Collections.singleton(this.identifier);
    }

    @Override
    public boolean test(R r) {
        if (r == null) {
            return false;
        }
        Object object = ((AbstractFeature)r).getValueOrFallback("sis:identifier", null);
        return object != null && this.identifier.equals(object.toString());
    }
}

