/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.commons.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.commons.marshall.jboss.SerializeWithExtFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.core.ExternalizerTable;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    final ExternalizerTable externalizerTable;
    ExternalizerTableProxy proxy;
    final GlobalConfiguration globalCfg;
    final InvocationContextContainer icc;

    public JBossMarshaller() {
        this.externalizerTable = null;
        this.globalCfg = null;
        this.icc = null;
    }

    public JBossMarshaller(ExternalizerTable externalizerTable, Configuration cfg, InvocationContextContainer icc, GlobalConfiguration globalCfg) {
        this.externalizerTable = externalizerTable;
        this.globalCfg = globalCfg;
        this.icc = icc;
    }

    public void start() {
        super.start();
        this.baseCfg.setClassExternalizerFactory((ClassExternalizerFactory)new SerializeWithExtFactory());
        this.proxy = new ExternalizerTableProxy(this.externalizerTable);
        this.baseCfg.setObjectTable((ObjectTable)this.proxy);
        Object classResolver = this.globalCfg.serialization().classResolver();
        if (classResolver == null) {
            ClassLoader cl = this.globalCfg.classLoader();
            classResolver = new EmbeddedContextClassResolver(cl, this.icc);
        }
        this.baseCfg.setClassResolver(classResolver);
    }

    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
        this.proxy.clear();
    }

    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || this.externalizerTable.isMarshallableCandidate(o) || o.getClass().getAnnotation(SerializeWith.class) != null || o.getClass().getAnnotation(Externalize.class) != null;
    }

    private static final class ExternalizerTableProxy
    implements ObjectTable {
        private ExternalizerTable externalizerTable;

        public ExternalizerTableProxy(ExternalizerTable externalizerTable) {
            this.externalizerTable = externalizerTable;
            log.tracef("Initialized proxy %s with table %s", (Object)this, (Object)externalizerTable);
        }

        public void clear() {
            this.externalizerTable = null;
            log.tracef("Cleared proxy %s", (Object)this);
        }

        public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
            return this.getExternalizerTable().getObjectWriter(o);
        }

        public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
            return this.getExternalizerTable().readObject(input);
        }

        private ExternalizerTable getExternalizerTable() {
            ExternalizerTable table = this.externalizerTable;
            if (table == null) {
                throw new IllegalLifecycleStateException("Cache marshaller has been stopped");
            }
            return table;
        }
    }

    public static final class EmbeddedContextClassResolver
    extends DefaultContextClassResolver {
        private final InvocationContextContainer icc;

        public EmbeddedContextClassResolver(ClassLoader defaultClassLoader, InvocationContextContainer icc) {
            super(defaultClassLoader);
            this.icc = icc;
        }

        protected ClassLoader getClassLoader() {
            ClassLoader cl;
            InvocationContext ctx;
            if (this.icc != null && (ctx = this.icc.getInvocationContext(true)) != null && (cl = ctx.getClassLoader()) != null) {
                return cl;
            }
            return super.getClassLoader();
        }
    }
}

