/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.image;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.processing.image.CompoundFuture;
import org.apache.sis.internal.system.CommonExecutor;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;

abstract class TiledProcess<R> {
    private static final int MIN_TILE_SIZE = 1000;
    private final AtomicInteger runningThreads;
    private final Task[] tasks;
    private final int yStride;
    private int taskIndex;
    private PixelIterator[] iterators;

    protected TiledProcess(RenderedImage renderedImage, int n, int n2, PixelIterator.Builder builder) {
        ArgumentChecks.ensurePositive((String)"overlapX", (int)n);
        ArgumentChecks.ensurePositive((String)"overlapY", (int)n2);
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        int n5 = Math.max(n3 / 1000, 1);
        int n6 = Math.max(n4 / 1000, 1);
        long l = JDK9.multiplyFull((int)n5, (int)n6);
        if (l > (long)CommonExecutor.PARALLELISM) {
            double d = Math.sqrt((double)CommonExecutor.PARALLELISM / (double)l);
            if (n5 >= n6) {
                n5 = Math.max((int)Math.round((double)n5 * d), 1);
                n6 = Math.max(Math.min(CommonExecutor.PARALLELISM / n5, n6), 1);
            } else {
                n6 = Math.max((int)Math.round((double)n6 * d), 1);
                n5 = Math.max(Math.min(CommonExecutor.PARALLELISM / n6, n5), 1);
            }
        }
        this.yStride = n5;
        this.tasks = new Task[n5 * n6];
        this.runningThreads = new AtomicInteger(this.tasks.length);
        int n7 = renderedImage.getMinX();
        int n8 = renderedImage.getMinY();
        int n9 = Math.addExact(n7, n3);
        int n10 = Math.addExact(n8, n4);
        int n11 = Numerics.ceilDiv((int)n3, (int)n5);
        int n12 = Numerics.ceilDiv((int)n4, (int)n6);
        Rectangle rectangle = new Rectangle(Math.addExact(n11, n), Math.addExact(n12, n2));
        int n13 = 0;
        this.iterators = new PixelIterator[this.tasks.length];
        rectangle.y = n8;
        while (rectangle.y < n10) {
            rectangle.x = n7;
            while (rectangle.x < n9) {
                this.iterators[n13++] = builder.setRegionOfInterest(rectangle).create(renderedImage);
                rectangle.x += n11;
            }
            rectangle.y += n12;
        }
        assert (n13 == this.tasks.length);
    }

    public final Future<R> execute() {
        Future[] futureArray = new Future[this.tasks.length];
        while (this.taskIndex < futureArray.length) {
            Task task = this.createSubTask();
            futureArray[this.taskIndex++] = CommonExecutor.instance().submit(task);
        }
        this.iterators = null;
        return CompoundFuture.create(futureArray);
    }

    protected abstract Task createSubTask();

    abstract class Task
    implements Callable<R> {
        private final int index;
        protected final PixelIterator iterator;
        private ReentrantLock merging;

        protected Task() {
            this.index = TiledProcess.this.taskIndex;
            this.iterator = TiledProcess.this.iterators[this.index];
        }

        protected abstract void execute() throws Exception;

        protected abstract void merge(Task var1) throws Exception;

        protected abstract R result() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final R call() throws Exception {
            int n;
            int n2;
            Task[] taskArray;
            block29: {
                this.execute();
                taskArray = TiledProcess.this.tasks;
                int n3 = TiledProcess.this.yStride;
                int n4 = this.index - this.index % n3;
                assert (this.merging == null);
                this.merging = new ReentrantLock();
                this.merging.lock();
                try {
                    Task[] taskArray2 = taskArray;
                    // MONITORENTER : taskArray
                    assert (taskArray[this.index] == null);
                    taskArray[this.index] = this;
                    // MONITOREXIT : taskArray2
                    n2 = 0;
                    int n5 = 0;
                    while (true) {
                        int n6;
                        switch (n5) {
                            default: {
                                if ((n2 & 3) == 0) break block29;
                                n2 = 0;
                                n5 = 0;
                            }
                            case 0: {
                                n6 = this.index - n3;
                                n = n6 >= 0 ? 1 : 0;
                                break;
                            }
                            case 1: {
                                n6 = this.index - 1;
                                n = n6 >= n4 ? 1 : 0;
                                break;
                            }
                            case 2: {
                                n6 = this.index + 1;
                                n = n6 < n4 + n3 ? 1 : 0;
                                break;
                            }
                            case 3: {
                                n6 = this.index + n3;
                                int n7 = n = n6 < taskArray.length ? 1 : 0;
                            }
                        }
                        if (n != 0) {
                            Task[] taskArray3 = taskArray;
                            // MONITORENTER : taskArray
                            Task task = taskArray[n6];
                            if (task == null || task == this || !task.merging.tryLock()) {
                                // MONITOREXIT : taskArray3
                            } else {
                                for (int i = 0; i < taskArray.length; ++i) {
                                    if (taskArray[i] != task) continue;
                                    taskArray[i] = this;
                                }
                                // MONITOREXIT : taskArray3
                                try {
                                    this.merge(task);
                                }
                                finally {
                                    task.merging.unlock();
                                }
                                ++n2;
                            }
                        }
                        ++n5;
                    }
                }
                finally {
                    this.merging.unlock();
                }
            }
            if (TiledProcess.this.runningThreads.decrementAndGet() != 0) {
                return null;
            }
            n2 = 0;
            while (n2 < taskArray.length) {
                Task task = taskArray[n2];
                if (task != null && task != this) {
                    assert (!task.merging.isLocked());
                    for (n = n2; n < taskArray.length; ++n) {
                        if (taskArray[n] != task) continue;
                        taskArray[n] = this;
                    }
                    this.merge(task);
                }
                ++n2;
            }
            return this.result();
        }
    }
}

