/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.commons.exception;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * @author: Tuan Nguyen
 * @version: $Id: ExoMessageException.java,v 1.2 2004/11/03 01:24:55 tuan08 Exp $
 * @since: 0.0
 * @email: tuan08@yahoo.com
 */
public class ExoMessageException extends ExoException {

  private String   messageKey_;

  private Object[] args_;

  public ExoMessageException(String messageKey) {
    messageKey_ = messageKey;
  }

  public ExoMessageException(String messageKey, Object[] args) {
    messageKey_ = messageKey;
    args_ = args;
  }

  public String getMessageKey() {
    return messageKey_;
  }

  public Object[] getArguments() {
    return args_;
  }

  public String getMessage(ResourceBundle res) {
    if (args_ == null) {
      return res.getString(messageKey_);
    }
    return MessageFormat.format(res.getString(messageKey_), args_);
  }

  public String getExceptionDescription() {
    return "Usually, this is not a critical exception. The exception is raised "
        + "when unexpected condition such wrong input, object not found...."
        + "The application should not crashed and it should continue working";
  }

  public String getErrorCode() {
    return "EXO ERROR: ";
  }
}
