/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractList;
import java.util.RandomAccess;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LazyList<E>
extends AbstractList<E>
implements RandomAccess {
    private static final Log LOG = ExoLogger.getLogger("exo.kernel.commons.LazyList");
    private final int batchSize;
    private Batch[] batches;
    private ListAccess<E> listAccess;

    public LazyList(ListAccess<E> listAccess, int batchSize) {
        if (listAccess == null) {
            throw new IllegalArgumentException("The list access object cannot be null");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("No batch size < 1 is accepted");
        }
        this.listAccess = listAccess;
        this.batchSize = batchSize;
    }

    @Override
    public E get(int index) {
        int size = this.size();
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index >= size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.batches == null) {
            this.batches = new Batch[1 + size / this.batchSize];
        }
        Object[] elements = null;
        int batchIndex = index / this.batchSize;
        Batch batch = this.batches[batchIndex];
        if (batch != null) {
            elements = batch.elements.get();
        }
        if (elements == null) {
            try {
                int loadedIndex = batchIndex * this.batchSize;
                int loadedLength = Math.min(this.batchSize, size - loadedIndex);
                elements = this.listAccess.load(loadedIndex, loadedLength);
                this.batches[batchIndex] = new Batch(elements);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
                throw new IllegalStateException("Cannot load resource at index " + index, e);
            }
        }
        return (E)elements[index % this.batchSize];
    }

    @Override
    public int size() {
        try {
            return this.listAccess.getSize();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot access resource size", e);
        }
    }

    private static class Batch {
        private final Reference<Object[]> elements;

        private Batch(Object[] elements) {
            this.elements = new SoftReference<Object[]>(elements);
        }
    }
}

