/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils.secure;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.exoplatform.commons.utils.secure.AbstractSecureCollectionsTest;
import org.exoplatform.commons.utils.secure.SecureCollections;

public class TestSecureList
extends AbstractSecureCollectionsTest {
    private List<String> list;

    protected void setUp() throws PrivilegedActionException {
        this.list = SecureCollections.secureList(new ArrayList(), (Permission)MODIFY_PERMISSION);
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.add("firstString");
                    TestSecureList.this.list.add("secondString");
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected void tearDown() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.clear();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureListAddDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.add("string");
                    return null;
                }
            }, new Permission[0]);
            TestSecureList.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureListAddPermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.add(0, "string");
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureList.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureListClearDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.clear();
                    return null;
                }
            }, new Permission[0]);
            TestSecureList.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureListIteratorRemovePermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    ListIterator<String> iterator = TestSecureList.this.list.listIterator();
                    iterator.next();
                    iterator.remove();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureList.fail((String)"Modification should be permitted.");
        }
    }

    public void testSecureListRemoveDenied() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    TestSecureList.this.list.remove(0);
                    return null;
                }
            }, new Permission[0]);
            TestSecureList.fail((String)"Modification should be denied.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSecureIteratorPermitted() throws PrivilegedActionException {
        try {
            this.doActionWithPermissions(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AccessControlException {
                    Iterator<String> it = TestSecureList.this.list.iterator();
                    return null;
                }
            }, MODIFY_PERMISSION);
        }
        catch (AccessControlException e) {
            TestSecureList.fail((String)"Modification should be permitted.");
        }
    }
}

