/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.concurrent.CacheState;
import org.exoplatform.services.cache.concurrent.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentFIFOExoCache
implements ExoCache {
    private static int DEFAULT_MAX_SIZE = 50;
    private final Log log;
    private volatile long liveTimeMillis;
    volatile int maxSize;
    private CacheListener[] listeners;
    private CacheState state;
    volatile int hits = 0;
    volatile int misses = 0;
    private String label;
    private String name;
    private boolean distributed = false;
    private boolean replicated = false;
    private boolean logEnabled = false;

    public ConcurrentFIFOExoCache() {
        this(DEFAULT_MAX_SIZE);
    }

    public ConcurrentFIFOExoCache(Log log) {
        this(DEFAULT_MAX_SIZE, log);
    }

    public ConcurrentFIFOExoCache(int maxSize) {
        this(null, maxSize);
    }

    public ConcurrentFIFOExoCache(int maxSize, Log log) {
        this(null, maxSize, log);
    }

    public ConcurrentFIFOExoCache(String name, int maxSize) {
        this(name, maxSize, null);
    }

    public ConcurrentFIFOExoCache(String name, int maxSize, Log log) {
        this.maxSize = maxSize;
        this.name = name;
        this.state = new CacheState(this, log);
        this.liveTimeMillis = -1L;
        this.log = log;
    }

    public void assertConsistent() {
        this.state.assertConsistency();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            if (this.name.length() > 30) {
                String shortLabel = this.name.substring(this.name.lastIndexOf(".") + 1);
                this.setLabel(shortLabel);
                return shortLabel;
            }
            return this.name;
        }
        return this.label;
    }

    @Override
    public void setLabel(String name) {
        this.label = name;
    }

    @Override
    public long getLiveTime() {
        return this.liveTimeMillis / 1000L;
    }

    @Override
    public void setLiveTime(long period) {
        this.liveTimeMillis = period >= 0L ? period * 1000L : -1L;
    }

    public long getLiveTimeMillis() {
        return this.liveTimeMillis;
    }

    public void setLiveTimeMillis(long liveTimeMillis) {
        this.liveTimeMillis = liveTimeMillis;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int max) {
        this.maxSize = max;
    }

    @Override
    public Object get(Serializable name) {
        if (name == null) {
            return null;
        }
        return this.state.get(name);
    }

    @Override
    public void put(Serializable name, Object obj) {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        long expirationTime = this.liveTimeMillis > 0L ? System.currentTimeMillis() + this.liveTimeMillis : Long.MAX_VALUE;
        this.state.put(expirationTime, name, obj);
    }

    @Override
    public void putMap(Map<Serializable, Object> objs) {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        long expirationTime = this.liveTimeMillis > 0L ? System.currentTimeMillis() + this.liveTimeMillis : Long.MAX_VALUE;
        for (Serializable serializable : objs.keySet()) {
            if (serializable != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        for (Map.Entry entry : objs.entrySet()) {
            this.state.put(expirationTime, (Serializable)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Serializable name) {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        return this.state.remove(name);
    }

    @Override
    public List getCachedObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (ObjectRef objectRef : this.state.map.values()) {
            Object object = objectRef.getObject();
            if (!objectRef.isValid()) continue;
            list.add(object);
        }
        return list;
    }

    @Override
    public List removeCachedObjects() throws Exception {
        List list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    @Override
    public void clearCache() {
        this.state = new CacheState(this, this.log);
    }

    @Override
    public void select(CachedObjectSelector selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Map.Entry<Serializable, ObjectRef> entry : this.state.map.entrySet()) {
            ObjectRef info;
            Serializable key = entry.getKey();
            if (!selector.select(key, info = entry.getValue())) continue;
            selector.onSelect(this, key, info);
        }
    }

    @Override
    public int getCacheSize() {
        return this.state.queue.size();
    }

    @Override
    public int getCacheHit() {
        return this.hits;
    }

    @Override
    public int getCacheMiss() {
        return this.misses;
    }

    @Override
    public synchronized void addCacheListener(CacheListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new CacheListener[]{listener};
        } else {
            CacheListener[] tmp = new CacheListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, tmp, 0, this.listeners.length);
            tmp[this.listeners.length] = listener;
            this.listeners = tmp;
        }
    }

    @Override
    public boolean isDistributed() {
        return this.distributed;
    }

    @Override
    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    @Override
    public boolean isReplicated() {
        return this.replicated;
    }

    @Override
    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    @Override
    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    void onExpire(Serializable key, Object obj) {
        if (this.listeners == null) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onExpire(this, key, obj);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    void onRemove(Serializable key, Object obj) {
        if (this.listeners == null) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onRemove(this, key, obj);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    void onPut(Serializable key, Object obj) {
        if (this.listeners == null) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onPut(this, key, obj);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    void onGet(Serializable key, Object obj) {
        if (this.listeners == null) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onGet(this, key, obj);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    void onClearCache() {
        if (this.listeners == null) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onClearCache(this);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }
}

